% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_aug_functions.R
\name{compliance_chain}
\alias{compliance_chain}
\title{Data Augmentation for Non-compliance analysis}
\usage{
compliance_chain(dat, outcome_model = NULL, exclusion_restriction = T,
  strong_access = T, starting_values = NULL, hyper_parameters = NULL,
  n_iter = 10000, n_burn = 1000)
}
\arguments{
\item{dat}{a data frame. The first column of the data frame should be the outcome variable,
the second column should be the treatment assignment variable, and the third column should be the
indicator for the treatment actually received.}

\item{outcome_model}{a character string indicating how the outcome should be modeled. Either "normal" for the
normal model or "binary" for the binary model.}

\item{exclusion_restriction}{a logical value indicating whether the exclusion restriction assumption should be made.}

\item{strong_access}{a logical value indicating whether the strong access monotonicity assumption should be made.}

\item{starting_values}{the initial parameter values. If NULL, then the initial parameter values are based on either a random draw
from the prior distribution (for the binary model) or sample statistics (for the normal model).}

\item{hyper_parameters}{a numerical vector containing the values that determine the prior distribution
for the model parameters. If NULL, then the hyper parameters are chosen to give non-informative or reference priors.}

\item{n_iter}{number of iterations of the data augmentation algorithm to perform.}

\item{n_burn}{number of initial iterations to discard.}
}
\value{
a matrix containing the draws from the posterior distribution.
}
\description{
\code{compliance_chain} fits a Bayesian non-compliance model by running a single chain of the data augmentation algorithm
}
\examples{
# runs 10 iterations of the data augmentation algorithm on a subset of the vitaminA data
set.seed(4923)
compliance_chain(vitaminA[sample(1:nrow(vitaminA), 1000),], outcome_model = "binary",
exclusion_restriction = TRUE, strong_access = TRUE, n_iter = 10, n_burn = 1)

}

