% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical.R
\name{nms_nonmem.model}
\alias{nms_nonmem.model}
\title{Generate NONMEM Names for Model}
\usage{
\method{nms_nonmem}{model}(x, ...)
}
\arguments{
\item{x}{a model designator}

\item{...}{passed arguments}
}
\value{
nms_nonmem (character)
}
\description{
Generates NONMEM names for parameters declared in a NONMEM control stream object.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% as.model \%>\% nms_nonmem

}
\seealso{
as.model

Other nms: 
\code{\link{as_nms_canonical}()},
\code{\link{as_nms_nonmem}()},
\code{\link{as_nms_pmx}()},
\code{\link{as_nms_psn}()},
\code{\link{nms_canonical}()},
\code{\link{nms_canonical.character}()},
\code{\link{nms_canonical.model}()},
\code{\link{nms_canonical.nms_nonmem}()},
\code{\link{nms_canonical.nms_pmx}()},
\code{\link{nms_canonical.numeric}()},
\code{\link{nms_nonmem}()},
\code{\link{nms_nonmem.character}()},
\code{\link{nms_nonmem.nms_canonical}()},
\code{\link{nms_nonmem.nms_pmx}()},
\code{\link{nms_nonmem.numeric}()},
\code{\link{nms_pmx}()},
\code{\link{nms_pmx.nms_canonical}()},
\code{\link{nms_pmx.nms_nonmem}()},
\code{\link{nms_psn}()},
\code{\link{nms_psn.character}()},
\code{\link{nms_psn.model}()},
\code{\link{nms_psn.numeric}()}
}
\concept{nms}
