% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparTrendR.R
\name{nonparTrendR_test}
\alias{nonparTrendR_test}
\title{Nonparametric Trend Test (Bathke, 2009)}
\usage{
nonparTrendR_test(data, type = c("I", "D"), alternative = NULL)
}
\arguments{
\item{data}{For `type = "I"` (independent samples), a list of numeric vectors,
where each vector represents a group. For `type = "D"` (dependent samples),
a numeric matrix where rows are subjects and columns are
conditions/time points (ordered by the expected trend).}

\item{type}{A character string specifying the type of data:
`"I"` for independent samples (uses Formula 2 from Bathke, 2009).
`"D"` for dependent samples (uses Formula 4 from Bathke, 2009, for an increasing trend).}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of `"two.sided"` (default for independent), `"increasing"`
(default for dependent), or `"decreasing"`.}
}
\value{
A list with class `"htest"` containing the following components:
  \item{statistic}{The value of the test statistic (\eqn{\nu}).}
  \item{p.value}{The p-value for the test.}
  \item{alternative}{A character string describing the alternative hypothesis.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name(s) of the data.}
}
\description{
Performs a nonparametric trend test for independent or dependent samples
based on Bathke (2009).
}
\examples{
# --- Independent Samples Example (Table 2 from paper) ---
group1_indep <- c(6.62, 6.65, 5.78, 5.63, 6.05, 6.48, 5.50, 5.37)
group2_indep <- c(6.25, 6.95, 5.61, 5.40, 6.89, 6.24, 5.85)
group3_indep <- c(7.11, 5.68, 6.23, 7.11, 5.55, 5.90, 5.98, 7.14)
group4_indep <- c(6.93, 7.17, 7.12, 6.43, 6.96, 7.08, 7.93)
group5_indep <- c(7.26, 6.45, 6.37, 6.54, 6.93, 6.40, 7.01, 7.74, 7.63, 7.62, 7.38)
data_independent <- list(group1_indep, group2_indep, group3_indep, group4_indep, group5_indep)
nonparTrendR_test(data_independent, type = "I", alternative = "increasing")

# --- Dependent Samples Example (Panic Data from paper) ---
panic_data_dep <- matrix(c(
  8, 6, 5, 5, 4,  8, 6, 5, 4, 2,  6, 5, 5, 4, 2,  6, 6, 6, 5, 5,
  7, 6, 6, 6, 6,  8, 7, 3, 2, 2,  7, 6, 7, 3, 3,  6, 4, 5, 3, 3,
  5, 4, 3, 3, 2,  8, 6, 5, 5, 4,  7, 6, 5, 4, 2,  6, 5, 5, 4, 2,
  6, 6, 6, 5, 5,  8, 6, 6, 6, 6,  8, 7, 4, 2, 2,  7, 6, 7, 3, 3
), nrow = 16, byrow = TRUE)
# For increasing trend test, data should be ordered such that higher values are expected later.
# If testing for decreasing trend as in your example, 
# reverse the columns or use alternative="decreasing"
# Example using original order, testing for decreasing:
nonparTrendR_test(panic_data_dep, type = "D", alternative = "decreasing")
# Example reversing columns to test for increasing trend of "improvement"
nonparTrendR_test(panic_data_dep[, 5:1], type = "D", alternative = "increasing")

}
\references{
Bathke, A. C. (2009). A unified approach to nonparametric trend tests
for dependent and independent samples. *Metrika*, 69(1), 17-29.
}
