% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{BlocksEndpoint}
\alias{BlocksEndpoint}
\title{R6 Class for Blocks Endpoint}
\value{
A list containing the parsed API response.
}
\description{
Handle all block operations in the Notion API

\strong{Note:} Access this endpoint through the client instance, e.g., \code{notion$blocks}. Not to be instantiated directly.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{notionapi::vcr_example_start("notion-blocks-retrieve")}
notion <- notion_client()

# ----- retrieve a block
notion$blocks$retrieve("23933ea0-c1e4-81dc-9f56-f3fa251a757f")
\dontshow{notionapi::vcr_example_end()}

# ----- update a block
\dontshow{notionapi::vcr_example_start("notion-blocks-update")}
notion$blocks$update(
  "23933ea0-c1e4-81dc-9f56-f3fa251a757f",
  heading_2 = list(
    rich_text = list(
      list(
        text = list(
          content = "Updated Test Heading"
        )
      )
    )
  )
)
\dontshow{notionapi::vcr_example_end()}

# ----- delete a block
\dontshow{notionapi::vcr_example_start("notion-blocks-delete")}
notion$blocks$delete(block_id = "23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba")
\dontshow{notionapi::vcr_example_end()}
\dontshow{\}) # examplesIf}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{children}}{Block children endpoint}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BlocksEndpoint-new}{\code{BlocksEndpoint$new()}}
\item \href{#method-BlocksEndpoint-retrieve}{\code{BlocksEndpoint$retrieve()}}
\item \href{#method-BlocksEndpoint-update}{\code{BlocksEndpoint$update()}}
\item \href{#method-BlocksEndpoint-delete}{\code{BlocksEndpoint$delete()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlocksEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-BlocksEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Initialise block endpoint.
Not to be called directly, e.g., use \code{notion$blocks} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlocksEndpoint$new(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Notion Client instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlocksEndpoint-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-BlocksEndpoint-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve a block
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlocksEndpoint$retrieve(block_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block_id}}{Character (required). The ID for a Notion block.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/retrieve-a-block}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlocksEndpoint-update"></a>}}
\if{latex}{\out{\hypertarget{method-BlocksEndpoint-update}{}}}
\subsection{Method \code{update()}}{
Update a block
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlocksEndpoint$update(block_id, archived = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block_id}}{Character (required). The ID for a Notion block.}

\item{\code{archived}}{Boolean. Set to TRUE to archive (delete) a block.
Set to FALSE to unarchive (restore) a block. Defaults to FALSE.}

\item{\code{...}}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Block-specific properties to update. Each argument should be named
after a \href{https://developers.notion.com/reference/block}{block type} (e.g., \code{heading_1}, \code{paragraph})
with a named list value containing the block configuration.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/update-a-block}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlocksEndpoint-delete"></a>}}
\if{latex}{\out{\hypertarget{method-BlocksEndpoint-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a block
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlocksEndpoint$delete(block_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block_id}}{Character (required). The ID for a Notion block.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/delete-a-block}{Endpoint documentation}
}

}
}
