% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_plot_richness.R
\name{plot_richness}
\alias{plot_richness}
\title{Plot richness of interview codes over time}
\usage{
plot_richness(
  score_df,
  refinements = integer(0),
  col = list(stroke_novel = "black", stroke_duplicate = "gray80", fill_novel = "black",
    fill_duplicate = "gray90")
)
}
\arguments{
\item{score_df}{(Dataframe) A dataframe of scored codes, as generated by \code{\link[=score_codes]{score_codes()}}.}

\item{refinements}{Either a list object generated by \code{\link[=import_field_notes]{import_field_notes()}}, or
an Integer vector that lists when (in terms of interview
sequence) refinements were made to the interview questions. For example,
\code{c(10, 15)} means that interview questions were revised twice: First \strong{before}
the 10th interview, and then again \strong{before} the 15th interview.}

\item{col}{(List) A List containing named Character vectors. Accepted names are:
\itemize{
\item \code{stroke_novel} and \code{stroke_duplicate} control line colours for novel and duplicate codes.
\item \code{fill_novel} and \code{fill_duplicate} control fill colours for novel and duplicate codes.
}}
}
\value{
A ggplot object.
}
\description{
The full definition of novel and duplicate codes is in \code{\link[=score_codes]{score_codes()}}.
Briefly, 'novel' codes are topics/ideas/concepts that were not mentioned in
previous interviews, whereas 'duplicate' codes are topics that other
interviews have discussed previously.

Some interviews will touch on many different topics and generate many different
codes, whereas other interviews will be brief or limited. We call this 'richness'.
This plot complements \code{\link[=plot_novelty]{plot_novelty()}} by visualising the richness of each
interview in terms of novel and duplicate codes, in context with any
refinements to interview questions that were made (marked by stars underneath
each bar). By examining this plot together with their field notes, researchers
can get insight into the effects of their refinements and the richness of the
data.
}
\examples{
# Field notes and coding matrices included with the package
path_to_notes    <- system.file("insect_study/records/refinements.xlsx", package = "novelqualcodes")
path_to_matrices <- system.file("insect_study/matrices/", package = "novelqualcodes")

# Import the data
my_refinements <- import_field_notes(path_to_notes)
my_matrices    <- import_coding_matrices(path_to_matrices)

# Score novel and duplicate codes
my_scores <- score_codes(my_matrices)

# Generate a plot with no refinements
plot_richness(score_df = my_scores)

# Generate a plot using scored codes and imported refinements
plot_richness(score_df = my_scores, refinements = my_refinements)

# Generate a plot using scored codes and a vector of refinement times
plot_richness(score_df = my_scores, refinements = c(4, 8, 10))

# Add colours!
plot_richness(
    score_df = my_scores,
    refinements = c(4, 8, 10),
    col = list(stroke_novel     = "lightblue",
               stroke_duplicate = "green",
               fill_novel       = "blue",
               fill_duplicate   = "orange")
)

}
\seealso{
\code{\link[=score_codes]{score_codes()}}, \code{\link[=import_field_notes]{import_field_notes()}}, \code{\link[=plot_novelty]{plot_novelty()}}, \code{\link[=save_last_plot]{save_last_plot()}}
}
