% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persimon_app.R
\name{persimon_app}
\alias{persimon_app}
\title{Run Shiny Application for bootFbar Performance Simulation}
\usage{
persimon_app(dbname, datatable, host, port, user, password)
}
\arguments{
\item{dbname}{A string specifying the name of the 'PostgreSQL' database to
connect to.}

\item{datatable}{A string specifying the name of the table in the database
where results will be stored.}

\item{host}{A string specifying the host name or IP address of the 'PostgreSQL'
server.}

\item{port}{An integer specifying the port number on which the 'PostgreSQL'
server is listening.}

\item{user}{A string specifying the username for the 'PostgreSQL' database
connection.}

\item{password}{A string specifying the password for the 'PostgreSQL'
database connection.}
}
\value{
A 'shiny' application object.
}
\description{
This function launches a 'shiny' application that allows users to run
performance simulations for the bootFbar method and other statistical tests.
The app provides an interface to set simulation parameters, run simulations,
view results, and store them in a 'PostgreSQL' database.
}
\details{
The 'shiny' application provides a user interface for setting simulation
parameters, running simulations using the \code{persimon} function, and visualizing
the results. It allows users to:
\itemize{
\item Set parameters for the simulation (means, standard deviations, sample sizes, etc.)
\item Run simulations with the specified parameters
\item View simulation results and success rates in interactive tables
\item Store simulation results in a PostgreSQL database
\item Download stored results from the database
\item View relevant citations for the methods used
}

The application uses the \code{mmints} package for database interactions and
citation handling.
}
\examples{
if(interactive()){
persimon_app(dbname = "my_database", datatable = "simulation_results",
             host = "localhost", port = 5432,
             user = "username", password = "password")
}

}
\seealso{
\code{\link{persimon}} for the underlying simulation function.
}
