% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paket_nph_2-1_1.R
\name{logrank.maxtest}
\alias{logrank.maxtest}
\alias{print.wlogrank_max}
\title{Maximum combination (MaxCombo) log-rank test}
\usage{
logrank.maxtest(
  time,
  event,
  group,
  alternative = c("two.sided", "less", "greater"),
  rho = c(0, 0, 1),
  gamma = c(0, 1, 0),
  event_time_weights = NULL,
  algorithm = mvtnorm::GenzBretz(maxpts = 50000, abseps = 1e-05, releps = 0)
)
}
\arguments{
\item{time}{Vector of observed event/censored times}

\item{event}{logical vector or numeric vector with entries 0 or 1, indicating if an event was observed (TRUE or 1) or the time is censored (FALSE or 0)}

\item{group}{Vector of group allocations}

\item{alternative}{Either of \code{"two.sided"},\code{"less"} or \code{"greater"}, specifies if two-sided or respective
one-sided p-values are calculated. In any case the z test statistic of each included weighted log-rank test
is based on the (weighted) sum of expected minus observed
events in the group corresponding to the first factor level of \code{group}. Hence a small value of the test statistic corresponds to a
lower (weighted average) hazard rate in the first group.}

\item{rho}{Vector of parameter values rho for a set of weighting functions in the rho-gamma family}

\item{gamma}{Vector of parameter values gamma for a set of weighting functions in the rho-gamma family}

\item{event_time_weights}{Optional matrix, each column containing a different weighting vector for the event times.
These weight vectors need to have one entry per event time (not per event, as multiple events may
occur at the same time) and must be sorted by increasing event time.}

\item{algorithm}{algorithm for the multivariate normal integration to be used in \code{\link[mvtnorm]{pmvnorm}}.}
}
\value{
A list with elements:
\describe{
\item{\code{pmult}}{The two sided p-value for the null hypothesis of equal hazard functions in both groups, based on the multivariate
normal approximation for the z-statistics of differently weighted log-rank tests.}
\item{\code{p.Bonf}}{The two sided p-value for the null hypothesis of equal hazard functions in both groups, based on a
Bonferroni multiplicity adjustment for differently weighted log-rank tests.}
\item{\code{tests}}{Data frame with z-statistics and two-sided unadjusted p-values of the individual weighted log-rank tests}
\item{\code{korr}}{Estimated correlation matrix for the z-statistics of the differently weighted log-rank tests.}
}
}
\description{
Calculates a MaxCombo test for the comparison of two groups based on the maximum of test statistics of a set of weighted log-rank tests
}
\details{
To perform a maximum-type combination test, a set of \eqn{m} different weight
functions \eqn{w_1(t), \dots, w_m(t)} is specified and the correspondingly
weighted logrank statistics \eqn{z_1,\dots,z_m} are calculated. The maximum
test statistic is \eqn{z_{max}=\max_{i=1,\dots,m} z_i}. If at least one of
the selected weight functions results in high power, we may expect a large
value of \eqn{z_{max}}.
Under the least favorable configuration in \eqn{H_0}, approximately
\eqn{(Z_1,\dots,Z_m)\sim N_m({0},{\Sigma})}. The p-value of the maximum
test, \eqn{P_{H_0}(Z_{max}>z_{max})=1-P(Z_1 \leq z_{max},\dots,Z_m \leq z_{max})},
is calculated based on this multivariate normal approximation via numeric integration.
The integration is done using \code{\link[mvtnorm]{pmvnorm}}. The default settings in
\code{logrank.maxtest} correspond to greater precision than the original default of
\code{\link[mvtnorm]{pmvnorm}}. Precision can be set via the argument \code{algorithm}.
Lower precision settings may speed up caclulation.

The multivariate normal approach automatically corrects for multiple testing with
different weights and does so efficiently since the correlation between the different
tests is incorporated in \eqn{{\Sigma}}. For actual calculations, \eqn{{\Sigma}} is
replaced by an estimate.
}
\examples{
A <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
B <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.1, 0.6, 0.1), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.04, 0.04), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
dat <- sample_fun(A, B, r0 = 0.5, eventEnd = 30,
  lambdaRecr = 0.5, lambdaCens = 0.25 / 365,
 maxRecrCalendarTime = 2 * 365,
 maxCalendar = 4 * 365)
logrank.maxtest(dat$y, dat$event, dat$group)

}
\references{
Robin Ristl, Nicolas Ballarini, Heiko Götte, Armin Schüler, Martin Posch, Franz König. Delayed treatment effects, treatment switching and
heterogeneous patient populations: How to design and analyze RCTs in oncology. Pharmaceutical statistics. 2021; 20(1):129-145.

Pranab Ghosh, Robin Ristl, Franz König, Martin Posch, Christopher Jennison, Heiko Götte, Armin Schüler, Cyrus Mehta. Robust group sequential
designs for trials with survival endpoints and delayed response. Biometrical Journal. First published online: 21 December 2021

Tarone RE. On the distribution of the maximum of the logrank statistic and the modified wilcoxon statistic. Biometrics. 1981; 37:79-85.

Lee S-H. On the versatility of the combination of the weighted log-rank statistics. Comput Stat Data Anal. 2007; 51(12):6557-6564.

Karrison TG et al. Versatile tests for comparing survival curves based on weighted log-rank statistics. Stata J. 2016; 16(3):678-690.
}
\seealso{
\code{\link{logrank.test}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
