% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_functions_1-1.R
\name{subpop_pchaz}
\alias{subpop_pchaz}
\title{Calculate survival for piecewise constant hazards with change after random time}
\usage{
subpop_pchaz(
  Tint,
  lambda1,
  lambda2,
  lambdaProg,
  timezero = FALSE,
  int_control = list(rel.tol = .Machine$double.eps^0.4, abs.tol = 1e-09),
  discrete_approximation = FALSE
)
}
\arguments{
\item{Tint}{vector of length \eqn{k+1}, for the boundaries of \eqn{k} time intervals (presumably in days) with piecewise constant hazard. The boundaries should be increasing and the first one should
be \code{0}, the last one should be larger than the assumed trial duration.}

\item{lambda1}{vector of length \eqn{k} for piecewise constant hazards before the changing event happens, for the intervals specified via \code{T}.}

\item{lambda2}{vector of length \eqn{k} for piecewise constant hazards after the changing event has happened, for the intervals specified via \code{T}.}

\item{lambdaProg}{vector of length \eqn{k} for piecewise constant hazards for the changing event, for the intervals specified via \code{T}.}

\item{timezero}{logical, indicating whether after the changeing event the timecount, governing which interval in \code{Tint} and which according value in
\code{lambda2} is used, should restart at zero.}

\item{int_control}{A list with the \code{rel.tol} and \code{abs.tol} paramaters to be passed to the  \code{\link{integrate}} function.}

\item{discrete_approximation}{if TRUE, the function uses an approximation based on discretizing the time, instead of integrating. This speeds up the calculations}
}
\value{
A list with class \code{mixpch} containing the following components:
\describe{
\item{\code{haz}}{Values of the hazard function.}
\item{\code{cumhaz}}{Values of the cumulative hazard function.}
\item{\code{S}}{Values of the survival function.}
\item{\code{F}}{Values of the distribution function.}
\item{\code{t}}{Time points for which the values of the different functions are calculated.}
\item{\code{Tint}}{Input vector of boundaries of time intervals.}
\item{\code{lambda1}}{Input vector of piecewise constant hazards before the changing event happen.}
\item{\code{lambda2}}{Input vector of piecewise constant hazards after the changing event happen.}
\item{\code{lambdaProg}}{Input vector of piecewise constant hazards for the changing event.}
\item{\code{funs}}{A list with functions to calculate the hazard, cumulative hazard, survival, and cdf over arbitrary continuous times.}
}
}
\description{
Calculates hazard, cumulative hazard, survival and distribution function
based on hazards that are constant over pre-specified time-intervals
}
\details{
We assume that the time to disease progression \eqn{T_{PD}} is governed
by a separate process with hazard function \eqn{\eta(t)},
which does not depend on the hazard function for death \eqn{\lambda(t)}.
\eqn{\eta(t)}, too, may be modelled as piecewise constant or, for simplicity,
as constant over time. We define \eqn{\lambda_{prePD}(t)} and \eqn{\lambda_{postPD}(t)}
as the hazard functions for death before and after disease progression.
Conditional on \eqn{T_{PD}=s}, the hazard function for death is
\eqn{\lambda(t|T_{PD}=s)=\lambda_{prePD}(t){I}_{t\leq s}+\lambda_{postPD}(t){I}_{t>s}}.
The conditional survival function is
\eqn{S(t|T_{PD}=s)=\exp(-\int_0^t \lambda(t|T_{PD}=s)ds)}.
The unconditional survival function results from integration over all
possible progression times as \eqn{S(t)=\int_0^t S(t|T_{PD}=s)dP(T_{PD}=s)}.
The output includes the function values calculated for all integer time points
between 0 and the maximum of \code{Tint}.
Additionally, a list with functions is also given to calculate the values at any arbitrary point \eqn{t}.
}
\examples{
subpop_pchaz(Tint = c(0, 40, 100), lambda1 = c(0.2, 0.4), lambda2 = c(0.1, 0.01),
lambdaProg = c(0.5, 0.4),timezero = FALSE, discrete_approximation = TRUE)
subpop_pchaz(Tint = c(0, 40, 100), lambda1 = c(0.2, 0.4), lambda2 = c(0.1, 0.01),
lambdaProg = c(0.5, 0.4), timezero = TRUE, discrete_approximation = TRUE)
}
\references{
Robin Ristl, Nicolas Ballarini, Heiko Götte, Armin Schüler, Martin Posch, Franz König. Delayed treatment effects, treatment switching and
heterogeneous patient populations: How to design and analyze RCTs in oncology. Pharmaceutical statistics. 2021; 20(1):129-145.
}
\seealso{
\code{\link{pchaz}}, \code{\link{pop_pchaz}}, \code{\link{plot.mixpch}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}, Nicolas Ballarini
}
