# ntsDists <img src="man/figures/logo.png" align="right"/>

[![R-CMD-check](https://github.com/dmazarei/ntsDists/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/dmazarei/ntsDists/actions/workflows/R-CMD-check.yaml)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/ntsDists)](https://cran.r-project.org/package=ntsDists)
[![Downloads per
month](https://cranlogs.r-pkg.org/badges/ntsDists)](https://cran.r-project.org/package=ntsDists)
[![Total
Downloads](https://cranlogs.r-pkg.org/badges/grand-total/ntsDists)](https://cran.r-project.org/package=ntsDists)
[![Licence](https://img.shields.io/badge/licence-GPL--3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0.en.html)

The R package *ntsDists* computes some measures of neutrosophic family
of distributions in the area of statistical analysis. More details can
be found Rao et al. (2023).

This work is funded by national funds through the FCT - Fundação para a
Ciência e a Tecnologia, I.P., under the scope of the projects
UIDB/00297/2020 and UIDP/00297/2020 (Center for Mathematics and
Applications)".

## Installation

You can install the **stable** version from
[CRAN](https://cran.r-project.org/package=ntsDists).

``` s
install.packages('ntsDists', dependencies = TRUE)
```

You can install the **development** version from
[Github](https://github.com/dmazarei/ntsDists)

``` s
# install.packages("remotes")
remotes::install_github("dmazarei/ntsDists")
```

## To cite package `ntsDists` in publications use:

Mazarei, D., Norouzirad, M., Roshani, A., Rao, G. S., Esmaeili, F. (2023). *ntsDists:
Neutrosophic distributions*. R package version 2.1.0,
<https://cran.r-project.org/package=ntsDists>.

A BibTeX entry for LaTeX users is

@Manual{ntsDists, title = {ntsDists: Neutrosophic distributions},
author = {Danial Mazarei and Mina Norouzirad and Amin Roshani and Gadde
Srinivasa Rao and Foad Esmaeili}, year = {2023}, note = {R package version 2.1.0}, url =
{<https://cran.r-project.org/package=ntsDists>} }

## License

This package is free and open source software, licensed under GPL-3.
