% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_plots.R
\name{lineup_histograms}
\alias{lineup_histograms}
\title{Check distributional assumptions using histograms and the lineup protocol.}
\usage{
lineup_histograms(
  data,
  variable,
  dist = NULL,
  params = NULL,
  color_bars = "black",
  fill_bars = "grey",
  color_lines = "brown3"
)
}
\arguments{
\item{data}{a data frame.}

\item{variable}{the name of the variable that should be plotted.}

\item{dist}{the null distribution name. One of: "beta", "cauchy",
"chi-squared", "exponential", "f", "gamma", "geometric", "log-normal",
"lognormal", "logistic", "negative binomial", "binomial", "normal",
"poisson", "t", "uniform", "weibull"}

\item{params}{list of parameters of distribution. If \code{NULL}, will
use \code{\link[MASS]{fitdistr}} to estimate them if possible. For
uniform, beta, and binomial distributions, the parameters must be specified.
See \code{?dunif}, \code{?dbeta}, and \code{?dbinom} for parameter names.}

\item{color_bars}{the color used for the borders of the bars. Can be a name
or a color HEX code.}

\item{fill_bars}{the color used to fill the bars.}

\item{color_lines}{the color used for the density curves.}
}
\value{
a \code{ggplot}
}
\description{
This function is used to quickly create lineup plots to check
distributional assumptions using histograms with kernel density estimates.
The null hypothesis is that the data follows the distribution specified by the
\code{dist} argument.
In the lineup protocol the plot of the real data is embedded amongst a field of
plots of data generated to be consistent with some null hypothesis.
If the observer can pick the real data as different from the others, this
lends weight to the statistical significance of the structure in the plot.
The protocol is described in Buja et al. (2009).
}
\details{
19 null datasets are plotted together the the true data (randomly
positioned)  If you pick the real data as being noticeably different, then
you have formally established that it is different to with p-value 0.05.

Run the \code{decrypt} message printed in the R Console to see which
plot represents the true data.
}
\examples{
data(tips)
lineup_histograms(tips, "total_bill", dist = "normal") # Normal distribution

# Some distributions require that the parameters be specified:
lineup_histograms(tips, "size", dist = "binomial", params = list(size = 6, p = 0.3))

# Style the plot using color settings and ggplot2 functions:
lineup_histograms(tips, "total_bill",
                  dist = "gamma",
                  color_bars = "steelblue",
                  color_lines = "magenta") +
    ggplot2::theme_minimal()
}
\references{
Buja, Cook, Hofmann, Lawrence, Lee, Swayne, Wickham. (2009).
Statistical inference for exploratory data analysis and model diagnostics,
\emph{Phil. Trans. R. Soc. A}, 367, 4361-4383.
}
\seealso{
null_dist
}
