% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments_number_of_distinct_alleles.R
\name{expected_number_of_distinct_alleles}
\alias{expected_number_of_distinct_alleles}
\title{Compute the expectation of the number of distinct alleles observed in a DNA mixture for a locus}
\usage{
expected_number_of_distinct_alleles(number_of_independent_alleles, f, fst = 0)
}
\arguments{
\item{number_of_independent_alleles}{Integer. Number of independent alleles in the mixture.}

\item{f}{Numeric vector with allele frequencies}

\item{fst}{Numeric value for sub-population correction (also known as theta)}
}
\value{
Expected value (numeric of length one)
}
\description{
For a given number of \emph{independent} alleles, compute the mean and variance of the number of \emph{distinct} alleles observed in a DNA mixture.
}
\details{
Due to allele sharing between DNA mixture contributors, the number of \emph{distinct} alleles observed in a mixture is often less than the number of independent alleles in the mixture. For example, if mixture comprises two unrelated contributors, there are four independent alleles. Some of these four independent alleles may be of the same allelic type so that at least one and at most four distinct alleles are observed.

This function computes the probability distribution of the number of \emph{distinct} alleles observed when the mixtures comprises a given number of \emph{independent} alleles. Optionally, a sub-population correction may be applied by setting \code{fst>0}.
}
\examples{
f <- c(A = 0.1, B = 0.2, C = 0.7)

e <- expected_number_of_distinct_alleles(3, f)

# by hand calculation
p <- pr_number_of_distinct_alleles(3, f)
e_by_hand <- sum(as.numeric(names(p)) * p)

stopifnot(isTRUE(all.equal(e, e_by_hand)))
}
