% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/splitCircle.R
\name{splitCircle}
\alias{splitCircle}
\title{Function for drawing a split circle (two differently colored semicircles)}
\usage{
splitCircle(x, y, radius, splitAngle = pi/4, nv = 100, border = NA,
  col1 = NA, col2 = NA, lty = 1, lwd = 1)
}
\arguments{
\item{x}{x location of the circle center}

\item{y}{y location of the circle center}

\item{radius}{radius of the circle}

\item{splitAngle}{angle (in radians) that splits the color in two halves}

\item{nv}{number of vertices used to draw the circle}

\item{border}{binary whether to include a border on the circle}

\item{col1}{color of the first semicircle}

\item{col2}{color of the second semicircle}

\item{lty}{line type used for drawing the circle polygon}

\item{lwd}{line width used for darwing the circle polygon}
}
\value{
none, split circle is drawn to the current device
}
\description{
Function for drawing a split circle (two differently colored semicircles)
}
\examples{
plot(-1, -1, xlim = c(0, 1), ylim = c(0,1), type = "n")
splitCircle(x = 0.5, y = 0.5, radius = 0.48,
		splitAngle = pi/4, nv = 1000, border = NA,
		col1 = "blue", col2 = "red")
}
\author{
Jason Waddell
}

