% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_assistants.R
\name{assistants_modify_assistant_request}
\alias{assistants_modify_assistant_request}
\title{API assistants: modify assistant}
\usage{
assistants_modify_assistant_request(
  assistant_id,
  model = NULL,
  name = NULL,
  description = NULL,
  instructions = NULL,
  tools = NULL,
  file_ids = NULL,
  metadata = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{assistant_id}{string, the ID of the assistant to modify}

\item{model}{string, ID of the model to use. You can use the List models API to see all of your available models, or
see our model overview (https://platform.openai.com/docs/models/overview) for descriptions of them.}

\item{name}{NULL/string, the name of the assistant. The maximum length is 256 characters.}

\item{description}{NULL/string, the description of the assistant. The maximum length is 512 characters.}

\item{instructions}{NULL/string, the system instructions that the assistant uses. The maximum length is 32768
characters.}

\item{tools}{NULL/list, a list of tool enabled on the assistant. There can be a maximum of 128 tools per
assistant. Tools can be of types code_interpreter, retrieval, or function.}

\item{file_ids}{NULL/character vector, a list of file IDs attached to this assistant. There can be a maximum of 20
files attached to the assistant. Files are ordered by their creation date in ascending order.}

\item{metadata}{NULL/list, set of 16 key-value pairs that can be attached to an object. This can be useful for
storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long
and values can be a maxium of 512 characters long.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Modifies an assistant. To get more details, visit
https://platform.openai.com/docs/api-reference/assistants/modifyAssistant
https://platform.openai.com/docs/assistants
}
