% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_files.R
\name{files_retrieve_content_request}
\alias{files_retrieve_content_request}
\title{API files: retrieve content request}
\usage{
files_retrieve_content_request(file_id, api_key = api_get_key())
}
\arguments{
\item{file_id}{string, id of the uploaded file}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
To get more details, visit https://platform.openai.com/docs/api-reference/files/retrieve-content
}
\examples{
\dontrun{
res_content <- files_retrieve_content_request("some-file-id")
if (!is_error(res_content)) {
  writeBin(res_content, "some-file.jsonl")
}
}

}
