% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.oceNPMLE.R
\name{plot.oceNPMLE}
\alias{plot.oceNPMLE}
\title{Plot \code{oceNPMLE} object.}
\usage{
\method{plot}{oceNPMLE}(
  x,
  xlab = "Ordering Score",
  ylab = "Proportion with a larger ordering score",
  ylim = c(0, 1),
  col = c("red", "blue"),
  mark.time = TRUE,
  ...
)
}
\arguments{
\item{x}{oceNPMLE object (see \code{\link{oceNPMLE}}).}

\item{xlab}{x label}

\item{ylab}{y label}

\item{ylim}{limits for the y axis, defaults to c(0,1)}

\item{col}{color vector, col[1] for group=0 and col[2] for group=1.}

\item{mark.time}{logical, should censored values be plotted?}

\item{...}{Extra arguments (e.g., lwd=2) added to  \code{lines} functions.}
}
\value{
No return value, called for side effects.
}
\description{
Plot \code{oceNPMLE} object.
}
\examples{
data(simScenario5)
dataFormt<-oceFormat(data=simScenario5, oceTime=c("T1","T2","T3"),
   oceStatus=c("I1","I2","I3"), group=c("Z"),
   oceNames = c("Death","Stroke/MI","Bleed"))
npmleOutput<- oceNPMLE(dataFormt)
plot(npmleOutput, xlab="Custom x label", mark.time=FALSE, lwd=2)
# can add lines from coxph output
coxOutput<- oceCoxph(dataFormt)
plot(coxOutput,linesonly=TRUE, col=c("orange","purple"),lwd=2)
legend("bottomleft",
   legend=c("grp=0, NPMLE","grp=1, NPMLE","grp=0, coxph","grp=1, coxph"),
   col=c("red","blue","orange","purple"),lty=c(1,1,1,1),lwd=2)

}
