% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.sontek.R
\name{advSontekAdrFileTrim}
\alias{advSontekAdrFileTrim}
\title{Trim a Sontek ADR adv File}
\usage{
advSontekAdrFileTrim(infile, n = 100, outfile, debug = getOption("oceDebug"))
}
\arguments{
\item{infile}{name of a Sontek ADR adp file.}

\item{n}{integer indicating the number of data chunks to keep. The default is
to keep 100 chunks, a common choice for sample files.}

\item{outfile}{optional name of the new Sontek ADR adp file to be created. If this is not
supplied, a default is used, by adding \verb{_trimmed} to the base filename, e.g.
if \code{infile} is \code{"x.adr"} then \code{outfile} will be \code{x_trimmed.adr}.}

\item{debug}{an integer value indicating the level of debugging. If
this is 1L, then a brief indication is given of the processing steps. If it
is > 1L, then information is given about each data chunk, which can yield
very extensive output.}
}
\value{
\code{advSontekAdrFileTrim()} returns the name of the output file, \code{outfile}, as
provided or constructed.
}
\description{
Create a Sontek ADR adv (acoustic Doppler velocimeter) file by copying the
header plus the first \code{n} data chunks (recognized by the three-byte sequence
\code{0xA5}, \code{0x11}, `0x3c') into a new file. This can be useful in supplying
small sample files for bug reports.
}
\seealso{
Other things related to adv data: 
\code{\link{[[,adv-method}},
\code{\link{[[<-,adv-method}},
\code{\link{adv}},
\code{\link{adv-class}},
\code{\link{applyMagneticDeclination,adv-method}},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{enuToOther}()},
\code{\link{enuToOtherAdv}()},
\code{\link{plot,adv-method}},
\code{\link{read.adv}()},
\code{\link{read.adv.nortek}()},
\code{\link{read.adv.sontek.adr}()},
\code{\link{read.adv.sontek.serial}()},
\code{\link{read.adv.sontek.text}()},
\code{\link{rotateAboutZ}()},
\code{\link{subset,adv-method}},
\code{\link{summary,adv-method}},
\code{\link{toEnu}()},
\code{\link{toEnuAdv}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnu}()},
\code{\link{xyzToEnuAdv}()}

Other functions that trim data files: 
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{oceFileTrim}()}
}
\concept{functions that trim data files}
\concept{things related to adv data}
