% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{subtractBottomVelocity}
\alias{subtractBottomVelocity}
\title{Subtract Bottom Velocity From an adp Object}
\usage{
subtractBottomVelocity(x, despike = FALSE, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an \linkS4class{adp} object that contains bottom-tracking velocities.}

\item{despike}{either a logical value or a univariate function. This
controls whether the bottom velocity (\code{bv}) values should be altered before they are
subtracted from the beam velocities. If it is \code{TRUE} then the \code{bv} values are despiked
first by calling \code{\link[=despike]{despike()}}. If it is a function, then that function is used instead of
\code{\link[=despike]{despike()}}, e.g. \code{function(x) despike(x, reference="smooth")} would change the reference
function for despiking from its default of \code{"median"}.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Subtracts bottom tracking velocities from an \code{"adp"} object. Works for
all coordinate systems (\code{beam}, \code{xyz}, and \code{enu}).
}
\seealso{
See \code{\link[=read.adp]{read.adp()}} for notes on functions relating to
\code{"adp"} objects, and \linkS4class{adp} for notes on the ADP
object class.

Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp}},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOther}()},
\code{\link{enuToOtherAdp}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp}()},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.aquadopp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{summary,adp-method}},
\code{\link{toEnu}()},
\code{\link{toEnuAdp}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnu}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnuAdpAD2CP}()}
}
\author{
Dan Kelley and Clark Richards
}
\concept{things related to adp data}
