% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceans.R
\docType{data}
\name{oceans}
\alias{oceans}
\title{Geometries of the five world oceans}
\usage{
data(oceans, package="ocedata")
}
\description{
Surface areas, average depths, and maximum depths for five world oceans,
calculated from the ETOPO-1 dataset.  Area is in square metres (converted
from square kilometres on the NOAA site), and depths are in metres.
}
\details{
The data were downloaded from the NOAA website
\url{https://ngdc.noaa.gov/mgg/global/etopo1_ocean_volumes.html} in October
2012.
}
\examples{
data(oceans, package="ocedata")
dotchart(oceans$Area, rownames(oceans), main="Surface Area [m^2]",
    xlim=c(0, max(oceans$Area)))

}
\references{
Amante, C. and B. W. Eakins, ETOPO1 1 Arc-Minute Global Relief
Model: Procedures, Data Sources and Analysis. NOAA Technical Memorandum
NESDIS NGDC-24, 19 pp, March 2009.
}
