% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{predict.ocf.forest}
\alias{predict.ocf.forest}
\title{Prediction Method for ocf.forest Objects}
\usage{
\method{predict}{ocf.forest}(object, data, type = "response", ...)
}
\arguments{
\item{object}{An \code{ocf.forest} object.}

\item{data}{Data set of class \code{data.frame}. It must contain at least the same covariates used to train the forests.}

\item{type}{Type of prediction. Either \code{"response"} or \code{"terminalNodes"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prediction results.
}
\description{
Prediction method for class \code{ocf.forest}.
}
\details{
If \code{type === "response"} (the default), the predicted conditional class probabilities are returned. If forests are 
honest, these predictions are honest.\cr

If \code{type == "terminalNodes"}, the IDs of the terminal node in each tree for each observation in \code{data} are returned.
}
\references{
\itemize{
  \item Di Francesco, R. (2025). Ordered Correlation Forest. Econometric Reviews, 1–17. \doi{10.1080/07474938.2024.2429596}.
}
}
\seealso{
\code{\link{ocf}}, \code{\link{marginal_effects}}
}
\author{
Riccardo Di Francesco
}
\keyword{internal}
