% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.r
\name{glance.harsm}
\alias{glance.harsm}
\alias{glance.hensm}
\title{Glance}
\usage{
\method{glance}{harsm}(x, ...)

\method{glance}{hensm}(x, ...)
}
\arguments{
\item{x}{an object of type \code{harsm} or \code{hensm}}

\item{...}{arguments for generic consistency.}
}
\value{
A glanced \code{tibble::tibble()} with fields
\describe{
 \item{df}{The degrees of freedom of the model.}
 \item{logLik}{The log-likelihood of the model.}
 \item{AIC}{Akaike's Information Criterion for the model.}
 \item{nobs}{The number of observations, if this is available, otherwise ‘NA’.}
}
}
\description{
Glance at a harsm, hensm or linodds model.
}
\details{
Returns a table with information on the overall fit
an estimated Harville or Henery model.
}
\note{
In the future this may include information about the regularization, if any.
}
\examples{

# softmax on the Best Picture data
data(best_picture)
df <- best_picture
df$place <- ifelse(df$winner,1,2)
df$weight <- ifelse(df$winner,1,0)

fmla <- place ~ nominated_for_BestDirector + nominated_for_BestActor + Drama
fit0 <- harsm(fmla,data=df,group=year,weights=weight)
print(glance(fit0))

}
\seealso{
\code{\link[maxLik]{glance.maxLik}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
