% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-merge_op.R
\name{merge_op}
\alias{merge_op}
\title{Concatenate classic and PROBIT estimates into a single data.frame}
\usage{
merge_op(x, y, prop2percent = FALSE)
}
\arguments{
\item{x}{Classic estimates data frame}

\item{y}{Probit estimates data frame}

\item{prop2percent}{Logical. Should proportion type indicators be converted
to percentage? Default is FALSE.}
}
\value{
A \code{\link[=data.frame]{data.frame()}} of combined classic and probit estimates.
}
\description{
Concatenate classic and PROBIT estimates into a single data.frame
}
\examples{
indicators <- c(
  "demo", "anthro", "food", "hunger", "adl", "disability",
  "mental", "dementia", "health", "oedema", "screening", "income",
  "wash", "visual", "misc"
)

classicIndicators <- indicators[indicators != "anthro"]

## Bootstrap classic
classicEstimates <- estimate_classic(
  x = indicators.ALL, w = testPSU, 
  indicators = classicIndicators, replicates = 9
)

probitEstimates <- estimate_probit(
  x = indicators.ALL, w = testPSU, replicates = 9
)

merge_op(x = classicEstimates, y = probitEstimates)

}
\author{
Ernest Guevarra
}
