% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBu-G.R
\name{OBuG}
\alias{OBuG}
\alias{pobug}
\alias{dobug}
\alias{qobug}
\alias{robug}
\alias{hobug}
\title{Odd Burr generated family of distributions (OBu-G)}
\usage{
pobug(x, alpha = 1, beta = 1, G = pnorm, ...)

dobug(x, alpha = 1, beta = 1, G = pnorm, ...)

qobug(q, alpha = 1, beta = 1, G = pnorm, ...)

robug(n, alpha = 1, beta = 1, G = pnorm, ...)

hobug(x, alpha = 1, beta = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{pobug} gives the distribution function,
 \code{dobug} gives the density,
 \code{qobug} gives the quantile function,
 \code{hobug} gives the hazard function and
 \code{robug} generates random variables from the Odd Burr generated family of
 distributions (OBu-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Alizadeh et al. (2017) specified by the pdf
\deqn{f=\frac{\alpha\beta\,g\,G^{\alpha-1}\bar{G}^{\alpha\,\beta-1}}{[G^\alpha+\bar{G}^\alpha]^{\beta+1}}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf,  \eqn{\alpha > 0}, the first shape parameter, and \eqn{\beta > 0}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
pobug(x)
pobug(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)

dobug(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(dobug, -3, 3)
qobug(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
robug(n, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
hobug(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hobug, -3, 3)
}
\references{
Alizadeh, M., Cordeiro, G. M., Nascimento, A. D., Lima, M. D. C. S., Ortega, E. M. (2017). Odd-Burr generalized family of distributions with some applications. Journal of statistical computation and simulation, 87(2), 367-389.
}
