% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-studentized-residual-plot.R
\name{ols_plot_resid_stud}
\alias{ols_plot_resid_stud}
\title{Studentized residual plot}
\usage{
ols_plot_resid_stud(model, threshold = NULL, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{threshold}{Threshold for detecting outliers. Default is 3.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_plot_resid_stud} returns  a list containing the
following components:

\item{outliers}{a \code{data.frame} with observation number and \code{studentized residuals} that
exceed \code{threshold}} for classifying an observation as an outlier
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Graph for identifying outliers.
}
\details{
Studentized deleted residuals (or externally studentized residuals) is the
deleted residual divided by its estimated standard deviation. Studentized
residuals are going to be more effective for detecting outlying Y
observations than standardized residuals. If an observation has an externally
studentized residual that is larger than 3 (in absolute value) we can call
it an outlier.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_resid_stud(model)
ols_plot_resid_stud(model, threshold = 2)

}
\seealso{
\code{\link[=ols_plot_resid_stand]{ols_plot_resid_stand()}}
}
