% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{plot_heatmap}
\usage{
plot_heatmap(
  cor_mat,
  scale = "none",
  show_rownames = FALSE,
  show_colnames = FALSE,
  labels_row = NULL,
  labels_col = NULL,
  breaks = seq(-1, 1, length.out = 101),
  legend_breaks = c(-1, -0.5, 0, 0.5, 1),
  legend_labels = c("-1.0", "-0.5", "0", "0.5", "1.0"),
  legend_name = "Correlation",
  output_path = NULL,
  display = TRUE,
  render_as = "png",
  width = 18,
  height = 16,
  dpi = 600
)
}
\arguments{
\item{cor_mat}{A numeric matrix representing the correlation values.}

\item{scale}{Character string indicating how to scale the data. Default is 'none'.}

\item{show_rownames}{Logical indicating whether to show row names. Default is FALSE.}

\item{show_colnames}{Logical indicating whether to show column names. Default is FALSE.}

\item{labels_row}{Character vector of labels for the rows. Default is NULL.}

\item{labels_col}{Character vector of labels for the columns. Default is NULL.}

\item{breaks}{Numeric vector of breakpoints for the heatmap colors. Default is seq(-1, 1, length.out = 101).}

\item{legend_breaks}{Numeric vector of breakpoints for the legend. Default is c(-1, -0.5, 0, 0.5, 1).}

\item{legend_labels}{Character vector of labels for the legend. Default is c("-1.0", "-0.5", "0", "0.5", "1.0").}

\item{legend_name}{Character string for the legend title. Default is 'Correlation'.}

\item{output_path}{Character string for the output file path. Default is NULL.}

\item{display}{Logical indicating whether to display the plot. Default is TRUE.}

\item{render_as}{Character string indicating the file format to save the plot. Default is 'png'.}

\item{width}{Numeric indicating the width of the plot. Default is 18.}

\item{height}{Numeric indicating the height of the plot. Default is 16.}

\item{dpi}{Numeric indicating the resolution of the plot. Default is 600.}
}
\value{
A heatmap plot.
}
\description{
Generate a heatmap for a given correlation matrix.
}
\details{
This function generates a heatmap for a given correlation matrix.
}
\author{
Zhen Lu \href{mailto:luzh29@mail2.sysu.edu.cn}{luzh29@mail2.sysu.edu.cn}
}
