% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG.R
\name{SVG_import}
\alias{SVG_import}
\title{Import an SVG file and create an \code{svg} object}
\usage{
SVG_import(
  data = NULL,
  width = NULL,
  height = NULL,
  viewbox = NULL,
  title = NULL,
  desc = NULL,
  incl_xmlns = FALSE,
  oneline = FALSE,
  anim_iterations = "infinite"
)
}
\arguments{
\item{data}{Either a file path to an SVG file or the SVG code itself as a
character vector of length 1.}

\item{width}{The width and height attributes on the top-level \verb{<svg>}
element. Both of these attributes are optional but, if provided, take in a
variety of dimensions and keywords. If numerical values are solely used,
they are assumed to be 'px' length values. Dimensions can be percentage
values (i.e., \code{"75\%"}) or length values with the following units: \code{"em"},
\code{"ex"}, \code{"px"}, \code{"in"}, \code{"cm"}, \code{"mm"}, \code{"pt"}, and \code{"pc"}. Using \code{NULL},
the default, excludes the attribute.}

\item{height}{The width and height attributes on the top-level \verb{<svg>}
element. Both of these attributes are optional but, if provided, take in a
variety of dimensions and keywords. If numerical values are solely used,
they are assumed to be 'px' length values. Dimensions can be percentage
values (i.e., \code{"75\%"}) or length values with the following units: \code{"em"},
\code{"ex"}, \code{"px"}, \code{"in"}, \code{"cm"}, \code{"mm"}, \code{"pt"}, and \code{"pc"}. Using \code{NULL},
the default, excludes the attribute.}

\item{viewbox}{An optional set of dimensions that defines the SVG \code{viewBox}
attribute. The \code{viewBox} for an SVG element is the position and dimension,
in user space, of an SVG viewport. If supplied, this could either be in the
form of a four-element, numeric vector corresponding to the \code{"min-x"},
\code{"min-y"}, \code{"width"}, and \code{"height"} of the rectangle, or, as \code{TRUE} which
uses the vector \code{c(0, 0, width, height)}. Using \code{NULL}, the default,
excludes this attribute.}

\item{title}{The \verb{<title>} tag for the finalized SVG.}

\item{desc}{The \verb{<desc>} tag for the finalized SVG.}

\item{incl_xmlns}{Should the \code{xmlns} attribute be included in the \verb{<svg>}
tag? This attribute is only required on the outermost \code{svg} element of SVG
documents, and, it's unnecessary for inner \code{svg} elements or inside of HTML
documents. By default, this is set to \code{FALSE}.}

\item{oneline}{An option to compress the resulting SVG tags such that they
are reduced to one line.}

\item{anim_iterations}{How many should an SVG animation (if defined by use of
the \code{\link[=anims]{anims()}} function) be played? By default this is \code{"infinite"} (i.e.,
looped indefinitely) but we can specify the animation iteration count as
a positive number.}
}
\value{
An \code{svg} object.
}
\description{
Import an SVG file and create an \code{svg} object
}
