% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG.R
\name{SVG_t}
\alias{SVG_t}
\title{Create a text-height \code{svg} object}
\usage{
SVG_t(height = "0.75em", viewbox)
}
\arguments{
\item{height}{The height attribute on the top-level \verb{<svg>} element. The
default of \code{"0.75em"} is recommended here so that SVGs are scaled nicely to
any adjacent text.}

\item{viewbox}{An optional set of dimensions that defines the SVG \code{viewBox}
attribute. The \code{viewBox} for an SVG element is the position and dimension,
in user space, of an SVG viewport. If supplied, this could either be in the
form of a four-element, numeric vector corresponding to the \code{"min-x"},
\code{"min-y"}, \code{"width"}, and \code{"height"} of the rectangle, or, as \code{TRUE} which
uses the vector \code{c(0, 0, width, height)}. Using \code{NULL}, the default,
excludes this attribute.}
}
\value{
An \code{svg} object.
}
\description{
The \code{SVG_t()} function is a variation on \code{\link[=SVG]{SVG()}} (the entry point for
building an SVG) in that the output tags will be both as compact as possible
(fewer linebreaks, less space characters) and the height is relative to line
height of text (at \code{"0.75em"}). This is a good option if the eventual use for
the generated SVG is to be integrated with text in HTML \verb{<p>} elements. For
scaling to function properly, the provision of the \code{viewbox} is required
here.
}
\examples{
if (interactive()) {

# Create a simple SVG with a rectangle and a circle
svg <-
  SVG_t(viewbox = c(0, 0, 60, 20)) \%>\%
  svg_rect(x = 0, y = 0, width = 30, height = 20) \%>\%
  svg_circle(x = 50, y = 10, diameter = 20)
}

}
