% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_dilate}
\alias{filter_dilate}
\title{Filter: add a dilation effect to an element}
\usage{
filter_dilate(radius = 1)
}
\arguments{
\item{radius}{The extent to which the source graphic will be dilated. If a
vector of two values are provided, the first value represents the x-radius
and the second one the y-radius. If one value is provided, then that value
is used for both x and y.}
}
\value{
An \code{svg} object.
}
\description{
The \code{filter_dilate()} filter applies a dilation effect to a source graphic by
a given \code{radius} value. The higher the \code{radius}, the greater the dilation
potential.
}
\examples{
if (interactive()) {

# Add a text element to an
# SVG drawing and erode it with
# the `filter_dilate()` filter
SVG(width = 200, height = 100) \%>\%
  svg_filter(
    id = "dilate",
    filters = list(
      filter_dilate(radius = c(0, 1))
    )
  ) \%>\%
  svg_text(
    x = 10, y = 40,
    text = "Dilation",
    attrs = svg_attrs_pres(
      font_size = "3em",
      filter = "dilate"
    )
  )
}

}
