% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_offset}
\alias{filter_offset}
\title{Filter: offset an element a specified amount}
\usage{
filter_offset(dx = NULL, dy = NULL, what = "source")
}
\arguments{
\item{dx, dy}{The offset of the element position compared to its initial
position.}

\item{what}{What exactly should be offset? By default, it is the \code{"source"}
image.}
}
\value{
An \code{svg} object.
}
\description{
The offset filter applies an offset in the x and y directions to an existing
element. The offset is handled by setting values for \code{dx} and \code{dy}.
}
\examples{
if (interactive()) {

# Add a circle element to an
# SVG drawing and offset it
# by 10px to the right
SVG(width = 150, height = 150) \%>\%
  svg_filter(
    id = "offset_right",
    filters = list(
      filter_offset(dx = 50, dy = 0)
    )
  ) \%>\%
  svg_circle(
    x = 30, y = 30,
    diameter = 40,
    attrs = svg_attrs_pres(
      fill = "red",
      filter = "offset_right"
    )
  )
}

}
