% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG.R
\name{SVG_}
\alias{SVG_}
\title{Create a compact \code{svg} object}
\usage{
SVG_(width = NULL, height = NULL, viewbox = TRUE)
}
\arguments{
\item{width}{The width and height attributes on the top-level \verb{<svg>}
element. Both of these attributes are optional but, if provided, take in a
variety of dimensions and keywords. If numerical values are solely used,
they are assumed to be 'px' length values. Dimensions can be percentage
values (i.e., \code{"75\%"}) or length values with the following units: \code{"em"},
\code{"ex"}, \code{"px"}, \code{"in"}, \code{"cm"}, \code{"mm"}, \code{"pt"}, and \code{"pc"}. Using \code{NULL},
the default, excludes the attribute.}

\item{height}{The width and height attributes on the top-level \verb{<svg>}
element. Both of these attributes are optional but, if provided, take in a
variety of dimensions and keywords. If numerical values are solely used,
they are assumed to be 'px' length values. Dimensions can be percentage
values (i.e., \code{"75\%"}) or length values with the following units: \code{"em"},
\code{"ex"}, \code{"px"}, \code{"in"}, \code{"cm"}, \code{"mm"}, \code{"pt"}, and \code{"pc"}. Using \code{NULL},
the default, excludes the attribute.}

\item{viewbox}{An optional set of dimensions that defines the SVG \code{viewBox}
attribute. The \code{viewBox} for an SVG element is the position and dimension,
in user space, of an SVG viewport. If supplied, this could either be in the
form of a four-element, numeric vector corresponding to the \code{"min-x"},
\code{"min-y"}, \code{"width"}, and \code{"height"} of the rectangle, or, as \code{TRUE} which
uses the vector \code{c(0, 0, width, height)}. Using \code{NULL}, the default,
excludes this attribute.}
}
\value{
An \code{svg} object.
}
\description{
The \code{SVG_()} function is a variation on \code{\link[=SVG]{SVG()}} (the entry point for building
an SVG) in that the output tags will be as compact as possible (fewer
linebreaks, less space characters). This is a reasonable option if the
eventual use for the generated SVG is as inline SVG within HTML documents.
}
\examples{
if (interactive()) {

# Create a simple SVG with a rectangle and a circle
svg <-
  SVG_(width = 100, height = 50) \%>\%
  svg_rect(x = 0, y = 0, width = 30, height = 20) \%>\%
  svg_circle(x = 50, y = 10, diameter = 20)
}

}
