% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_circle}
\alias{svg_circle}
\title{Addition of a \code{circle} element}
\usage{
svg_circle(
  svg,
  x,
  y,
  diameter,
  stroke = NULL,
  stroke_width = NULL,
  fill = NULL,
  opacity = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{x, y}{The \code{x} and \code{y} positions of the center of the circle to be drawn.
The \code{x} and \code{y} values are relative to upper left of the SVG drawing area.}

\item{diameter}{The diameter of the circle shape in units of \code{px}.}

\item{stroke}{The color of the stroke applied to the element (i.e., the
outline).}

\item{stroke_width}{The width of the stroke in units of pixels.}

\item{fill}{The fill color of the element.}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_circle()} function adds a circle to an \code{svg} object. The position of
the circle is given by \code{x} and \code{y}, and this refers to the center point of
the point of the circle. The \code{diameter} of the circle is given in units of
\code{px}.
}
\examples{
if (interactive()) {

# Create an SVG with a single
# circle element
svg <-
  SVG(width = 80, height = 80) \%>\%
    svg_circle(
      x = 30, y = 30,
      diameter = 40,
      stroke = "magenta",
      fill = "olive"
    )
}

}
