% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theme_info.R
\name{get_theme_info}
\alias{get_theme_info}
\title{Get Theme Information}
\usage{
get_theme_info(token, theme)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{theme}{Query name of theme. Themes’ query names can be retrieved using \code{\link{search_themes}}.}
}
\value{
A named character vector of Theme Name and Query Name.
If an error occurred, the function throws an error with the status code and API's error message.
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/apidocs/themes/#getThemesInfo}{Get Theme Info API}. It returns a named character vector of Theme Name and Query Name.
}
\examples{
# returns named character vector
\dontrun{get_theme_info(token, "kindergartens")}

# throws an error with error message and status code
\dontrun{get_theme_info(token, "invalid_theme")}

# throws an error with error message and status code
\dontrun{get_theme_info("invalid_token", "blood_bank")}
}
