% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{onetime_dir}
\alias{onetime_dir}
\title{Return a path to a directory beneath the onetime base directory}
\usage{
onetime_dir(dir)
}
\arguments{
\item{dir}{String. Name of a single directory.}
}
\value{
The path.
}
\description{
By default lockfiles are stored beneath the onetime base directory,
in a directory named after the calling package. You can use a different
subdirectory by setting \code{path = onetime_dir("dirname")} in calls to
onetime functions.
}
\details{
\code{onetime_dir()} does not autocreate the directory (but it will get created
during the call to  \code{\link[=onetime_do]{onetime_do()}}).
}
\examples{
onetime_dir("my-folder")
oo <- options(onetime.dir = tempdir(check = TRUE))
onetime_dir("my-folder")
options(oo)
}
