% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagdf.R
\name{lagdf.matrix}
\alias{lagdf.matrix}
\title{Lagging which returns a data.frame}
\usage{
\method{lagdf}{matrix}(x, lagseq)
}
\arguments{
\item{x}{The data.frame to have columns lagged}

\item{lagseq}{The sequence of lags as an integer. Alternatively, as a character "+k", "-k", "+h" or "-h", e.g. "k12" will with "+k" be lagged 12.}
}
\value{
A data.frame.

A data.frame with columns that are lagged
}
\description{
Lagging by shifting the values back or fourth always returning a data.frame.

Lagging of a data.frame
}
\details{
This function lags (shifts) the values of the vector. A data.frame is always returned with the columns
as the vectors lagged with the values in lagseq. The column names are set to "kxx", where xx are the lag of the column.

This function lags the columns with the integer values specified with the argument \code{lagseq}.
}
\examples{
# The values are simply shifted
# Ahead in time
lagdf(1:10, 3)
# Back in time
lagdf(1:10, -3)
# Works but returns a numeric column
lagdf(as.factor(1:10), 3)
# Works and returns a character column
lagdf(as.character(1:10), 3)
# Giving several lag values
lagdf(1:10, c(1:3))
lagdf(1:10, c(5,3,-1))

# See also how to lag a forecast data.frame with: ?lagdf.data.frame



# dataframe of forecasts
X <- data.frame(k1=1:10, k2=1:10, k3=1:10)
X

# Lag all columns
lagdf(X, 1)
\dontshow{if(!all(is.na(lagdf(X, 1)[1, ]))){stop("Lag all columns didn't work")}}

# Lag each column different steps
lagdf(X, 1:3)
# Lag each columns with its k value from the column name
lagdf(X, "+k")
\dontshow{
    if(any(lagdf(X, 1:3) != lagdf(X, "+k"),na.rm=TRUE)){stop("Couldn't lag +k")}
}
# Also works for columns named hxx
names(X) <- gsub("k", "h", names(X))
lagdf(X, "-h")

# If lagseq must have length as columns in X, it doesn't know how to lag and an error is thrown
try(lagdf(X, 1:2))

\dontshow{
if(!class(lagdf(data.frame(k1=1:10), 2)) == "data.frame"){stop("Trying to lag data.frame with 1 column, but return is not class data.frame")}
if(!all(dim(lagdf(data.frame(k1=1:10), "+k")) == c(10,1))){stop("Trying to lag data.frame with 1 column, but return is not class data.frame")}
}

}
\seealso{
\code{\link{lagdf.data.frame}} which is run when \code{x} is a data.frame.
}
