% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistence.R
\name{persistence}
\alias{persistence}
\title{Generate persistence forecasts}
\usage{
persistence(y, kseq, perlen = NA)
}
\arguments{
\item{y}{(numeric) The model output to be forecasted.}

\item{kseq}{(integer) The horizons to be forecasted.}

\item{perlen}{(integer) The period length for seasonal persistence.}
}
\value{
Forecast matrix as a \code{data.frame} (named \code{Yhat} in similar functions)
}
\description{
Generate persistence and periodic persistence forecasts
}
\details{
Generate a forecast matrix using persistence. The simple persistence is with the current value of y, i.e. the value at time t is used as forecast

A seasonal persistence with a specific period can be generated by setting the argument \code{perlen} to the length of the period in steps. The value used for the forecast is then the latest available, which is matches the seasonality for time t+k, see the examples.
}
\examples{

# Simple persistence just copies the current value for the forecasts
persistence(1:10, kseq=1:4)

# Seasonal persistence takes the value perlen steps back
persistence(1:10, kseq=1:4, perlen=4)

# If the horizons are longer than perlen, then the perlen*i steps back is taken (i is an integer)
persistence(1:10, kseq=1:12, perlen=4)


}
