% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_mapping.R
\name{new_mapping}
\alias{new_mapping}
\title{Add a new mapping to an ontology}
\usage{
new_mapping(
  new = NULL,
  target,
  source = NULL,
  lut = NULL,
  match = NULL,
  certainty = NULL,
  type = "concept",
  ontology = NULL,
  verbose = FALSE,
  beep = NULL
)
}
\arguments{
\item{new}{\code{\link[=character]{character(.)}}\cr the english external label(s) that
shall be mapped to labels that do already exist in the ontology.}

\item{target}{\code{\link[=data.frame]{data.frame(.)}}\cr the already harmonised English
label(s) to which the external labels shall be mapped; derive with get_concept().}

\item{source}{\code{\link[=character]{character(1)}}\cr any character uniquely
identifying the source dataset of the new label.}

\item{lut}{\code{\link[=character]{character(.)}}\cr in case the terms used for mapping
are from a look up table (i.e. a standardised set of terms with a
description), provide this table with column names 'label' and
'description' here.}

\item{match}{\code{\link[=character]{character(1)}}\cr the
\href{https://www.w3.org/TR/skos-reference/#mapping}{skos mapping property}
used to describe the link, possible values are \code{"close"},
\code{"exact"}, \code{"broad"} and \code{"narrow"}.}

\item{certainty}{\code{\link[=integer]{integerish(1)}}\cr the certainty of the match.
Possible values are between 1 and 4, with meaning \itemize{\item 1 =
probably unreliable \item 2 = unclear, assigned according to a given
definition \item 3 = clear, assigned according to a given definition \item
4 = original, harmonised term (can't be assigned by a user)}.}

\item{type}{\code{\link[=character]{character(1)}}\cr whether the new labels are mapped
to a \code{"concept"}, or to a \code{"class"}.}

\item{ontology}{\code{\link[=list]{ontology(1)}}\cr either a path where the ontology is
stored, or an already loaded ontology.}

\item{verbose}{\code{\link[=logical]{logical(1)}}\cr whether or not to give detailed
information on the process of this function.}

\item{beep}{\code{\link[=integer]{integerish(1)}}\cr Number specifying what sound to be
played to signal the user that a point of interaction is reached by the
program, see \code{\link[beepr]{beep}}.}
}
\value{
No return value, called for the side effect of adding new mappings to
an ontology.
}
\description{
Extend an ontology by creating mappings between classes and concepts of
external vocabularies and the harmonised classes and concepts.
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")
onto <- load_ontology(path = ontoDir)

mapping <- data.frame(old = c("BIOENERGY CROPS", "Bioenergy woody",
                              "Other bioenergy crops"),
                      new = c("bioenergy plants", "Wood plantation for fuel",
                              "Algae for bioenergy"),
                      type = c("close", "broader", "broader"))

onto <- new_source(name = "externalDataset",
                   version = "0.0.1",
                   description = "a vocabulary",
                   homepage = "https://www.something.net",
                   license = "CC-BY-0",
                   ontology = onto)

onto <- get_concept(label = mapping$old, ontology = onto) \%>\%
  new_mapping(new = mapping$new,
              target = .,
              match = mapping$type,
              source = "externalDataset",
              certainty = 3,
              ontology = onto)

}
