% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-sim.R
\name{sample_group_sim}
\alias{sample_group_sim}
\alias{sample_group_sim.integer}
\alias{sample_group_sim.numeric}
\alias{sample_group_sim.matrix}
\alias{sample_group_sim.sim_index}
\alias{sample_group_sim.default}
\title{Draw sample of group similarities}
\usage{
sample_group_sim(pop_sim, ...)

\method{sample_group_sim}{integer}(pop_sim, ...)

\method{sample_group_sim}{numeric}(pop_sim, ...)

\method{sample_group_sim}{matrix}(pop_sim, ...)

\method{sample_group_sim}{sim_index}(pop_sim, ...)

\method{sample_group_sim}{default}(
  pop_sim,
  type,
  group_size,
  group_sim = "average",
  sample_size = 10000,
  ...
)
}
\arguments{
\item{pop_sim}{An object representing the similarities of an indexed population of objects.}

\item{...}{Other arguments to be passed to \code{sample_group_sim}.}

\item{type}{Either "matrix", "sim_index" or "numeric" - the type of the \code{pop_sim} object.}

\item{group_size}{Integer giving the number of members of a group.}

\item{group_sim}{String Either "average" or "min", determining how to calculate the similarity of a group of term sets over all pairwise combinations of group members}

\item{sample_size}{Number of samples to draw.}
}
\value{
Numeric vector of random group similarities.
}
\description{
Draw sample of group similarities of groups of given size
}
\seealso{
\code{\link{get_sim}} \code{\link{get_sim_p}}
}
