% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.R
\name{opal.file_unzip}
\alias{opal.file_unzip}
\title{Unzip a zip archive file}
\usage{
opal.file_unzip(opal, source, destination, key = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{source}{Path to the file in the Opal file system (must exist and have the ".zip" file extension).}

\item{destination}{Path to the destination file or folder in the Opal file system.}

\item{key}{Key to decrypt archive.}
}
\value{
The path of the extracted archive folder in the Opal file system.
}
\description{
Unzip a zip archive file from the Opal file system.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# unzip
path <- opal.file_unzip(o, "/tmp/TESTING.zip", "/home/administrator")
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file}()},
\code{\link{opal.file_cp}()},
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mkdir}()},
\code{\link{opal.file_mkdir_tmp}()},
\code{\link{opal.file_mv}()},
\code{\link{opal.file_read}()},
\code{\link{opal.file_rm}()},
\code{\link{opal.file_upload}()},
\code{\link{opal.file_write}()}
}
\concept{file functions}
