% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootMeans.R
\name{binData}
\alias{binData}
\alias{bootMeanDF}
\title{Bin data, calculate mean and bootstrap confidence interval in the mean}
\usage{
binData(
  mydata,
  bin = "nox",
  uncer = "no2",
  type = "default",
  n = 40,
  interval = NA,
  breaks = NA,
  conf.int = 0.95,
  B = 250,
  ...
)

bootMeanDF(x, conf.int = 0.95, B = 1000)
}
\arguments{
\item{mydata}{Name of the data frame to process.}

\item{bin}{The name of the column to divide into intervals.}

\item{uncer}{The name of the column for which the mean, lower and upper
uncertainties should be calculated for each interval of \code{bin}.}

\item{type}{Used for splitting the data further. Passed to \code{\link[=cutData]{cutData()}}. Note
that intervals are calculated on the whole dataset before the data is
categorised, meaning intervals will be the same for the different groups.}

\item{n}{The number of intervals to split \code{bin} into.}

\item{interval}{The interval to be used for binning the data.}

\item{breaks}{User specified breaks to use for binning.}

\item{conf.int}{The confidence interval, defaulting to \code{0.95} (i.e., the 95\%
Confidence Interval).}

\item{B}{The number of bootstrap simulations.}

\item{...}{Other parameters that are passed on to \code{\link[=cutData]{cutData()}}, for use with
\code{type}.}

\item{x}{A vector from which the mean and bootstrap confidence intervals in
the mean are to be calculated}
}
\value{
Returns a summarised data frame with new columns for the mean and
upper / lower confidence intervals in the mean.
}
\description{
\code{\link[=binData]{binData()}} summarises data by intervals and calculates the mean and
bootstrap confidence intervals (by default 95\% CI) in the mean of a chosen
variable in a data frame. Any other numeric variables are summarised by their
mean intervals. This occurs via \code{\link[=bootMeanDF]{bootMeanDF()}}, which calculates the
uncertainty intervals in the mean of a vector.
}
\details{
There are three options for binning. The default is to bin \code{bin} into 40
intervals. Second, the user can choose an binning \code{interval}, e.g., \code{interval = 5}. Third, the user can supply their own \code{breaks} to use as binning
intervals. Note that intervals are calculated on the whole dataset before the
data is cut into categories using \code{type}.
}
\examples{
# work with vectors
test <- rnorm(20, mean = 10)
bootMeanDF(test)

# how does nox vary by intervals of wind speed?
results <- binData(mydata, bin = "ws", uncer = "nox")
\dontrun{
library(ggplot2)
ggplot(results, aes(x = ws, y = mean, ymin = min, ymax = max)) +
  geom_pointrange()
}

# what about weekend vs weekday?
results2 <- binData(mydata, bin = "ws", uncer = "nox", type = "weekend")
\dontrun{
ggplot(results2, aes(x = ws, y = mean, ymin = min, ymax = max)) +
  geom_pointrange() +
  facet_wrap(vars(weekend))
}

}
