% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPolarMarkers.R
\name{addPolarMarkers}
\alias{addPolarMarkers}
\alias{addPolarDiffMarkers}
\title{Add polar markers to leaflet map}
\usage{
addPolarMarkers(
  map,
  pollutant,
  fun = openair::polarPlot,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  key = FALSE,
  d.icon = 200,
  d.fig = 3.5,
  data = leaflet::getMapData(map),
  ...
)

addPolarDiffMarkers(
  map,
  pollutant,
  before = leaflet::getMapData(map),
  after = leaflet::getMapData(map),
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  key = FALSE,
  d.icon = 200,
  d.fig = 3.5,
  ...
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{pollutant}{The name of the pollutant to be plot. Note that, if \code{fun = openair::windRose}, you must set \code{pollutant = "ws"}.}

\item{fun}{An \code{openair} directional analysis plotting function. Supported
functions include \code{\link[openair:polarPlot]{openair::polarPlot()}} (the default),
\code{\link[openair:polarAnnulus]{openair::polarAnnulus()}}, \code{\link[openair:polarFreq]{openair::polarFreq()}},
\code{\link[openair:percentileRose]{openair::percentileRose()}}, \code{\link[openair:pollutionRose]{openair::pollutionRose()}} and
\code{\link[openair:windRose]{openair::windRose()}}. For \code{\link[openair:polarDiff]{openair::polarDiff()}}, use
\code{\link[=addPolarDiffMarkers]{addPolarDiffMarkers()}}.}

\item{lng}{The decimal longitude.}

\item{lat}{The decimal latitude.}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{popup}{A column of \code{data} to be used as a popup.}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{A column of \code{data} to be used as a label.}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
 you can use \code{\link[leaflet]{markerClusterOptions}()} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{d.icon}{The diameter of the plot on the map in pixels. This will affect
the size of the individual polar markers. Alternatively, a vector in the
form \code{c(width, height)} can be provided if a non-circular marker is
desired.}

\item{d.fig}{The diameter of the plots to be produced using \code{openair} in
inches. This will affect the resolution of the markers on the map.
Alternatively, a vector in the form \code{c(width, height)} can be provided if a
non-circular marker is desired.}

\item{data}{A data frame. The data frame must contain the data to plot your
choice of openair directional analysis plot, which includes wind speed
(\code{ws}), wind direction (\code{wd}), and the column representing the
concentration of a pollutant. In addition, \code{data} must include a decimal
latitude and longitude. By default, it is the data object provided to
\code{\link[leaflet:leaflet]{leaflet::leaflet()}} initially, but can be overridden.}

\item{...}{Other arguments for the plotting function (e.g. \code{period} for
\code{\link[openair:polarAnnulus]{openair::polarAnnulus()}}).}

\item{before, after}{A data frame that represents the before/after case. See
\code{\link[openair:polarPlot]{openair::polarPlot()}} for details of different input requirements. By
default, both \code{before} and \code{after} are the data object provided to
\code{\link[leaflet:leaflet]{leaflet::leaflet()}} initially, but at least one should be overridden.}
}
\value{
A leaflet object.
}
\description{
This function is similar (but not identical to) the \code{\link[leaflet:map-layers]{leaflet::addMarkers()}}
and \code{\link[leaflet:map-layers]{leaflet::addCircleMarkers()}} functions in \code{leaflet}, which allows users
to add \code{openair} directional analysis plots to any leaflet map and have more
control over groups and layerIds than in "all-in-one" functions like
\code{\link[=polarMap]{polarMap()}}.
}
\section{Functions}{
\itemize{
\item \code{addPolarMarkers()}: Add any one-table polar marker (e.g.,
\code{\link[openair:polarPlot]{openair::polarPlot()}})

\item \code{addPolarDiffMarkers()}: Add the two-table \code{\link[openair:polarDiff]{openair::polarDiff()}} marker.

}}
\examples{
\dontrun{
library(leaflet)
library(openair)

# different types of polar plot on one map
leaflet(data = polar_data) \%>\%
  addTiles() \%>\%
  addPolarMarkers("ws",
    fun = openair::windRose,
    group = "Wind Rose"
  ) \%>\%
  addPolarMarkers("nox",
    fun = openair::polarPlot,
    group = "Polar Plot"
  ) \%>\%
  addLayersControl(
    baseGroups = c("Wind Rose", "Polar Plot")
  )

# use of polar diff (NB: both 'before' and 'after' inherit from `leaflet()`,
# so at least one should be overridden - in this case 'after')
leaflet(data = polar_data) \%>\%
  addTiles() \%>\%
  addPolarDiffMarkers("nox",
    after = dplyr::mutate(polar_data, nox = jitter(nox, 5))
  )
}
}
\seealso{
\code{shiny::runExample(package = "openairmaps")} to see examples of this
function used in a \code{\link[shiny:shinyApp]{shiny::shinyApp()}}
}
