% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{buildPopup}
\alias{buildPopup}
\title{Build a Complex Popup for a Leaflet Map}
\usage{
buildPopup(
  data,
  columns,
  latitude = NULL,
  longitude = NULL,
  type = NULL,
  fun.character = function(x) paste(unique(x), collapse = ", "),
  fun.numeric = function(x) signif(mean(x, na.rm = TRUE), 3),
  fun.dttm = function(x) paste(lubridate::floor_date(range(x, na.rm = TRUE), "day"),
    collapse = " to "),
  ...
)
}
\arguments{
\item{data}{\emph{Input data table with geo-spatial information.}

\strong{required}

A data frame containing latitude and longitude information that will go on
to be used in a function such as \code{\link[=polarMap]{polarMap()}}.}

\item{columns}{\emph{A character vector of column names to include in the popup.}

\strong{required}

Summaries of the selected columns will appear in the popup. If a named
vector is provided, the names of the vector will be used in place of the
raw column names. See the Examples for more information.}

\item{latitude, longitude}{\emph{The decimal latitude(Y)/longitude(X).}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Column names representing the decimal latitude and longitude (or other Y/X
coordinate if using a different \code{crs}). If not provided, will be
automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{type}{\emph{A column to be passed to the \code{type} argument of another
function.}

\emph{default:} \code{NULL}

Column which will be used for the \code{type} argument of other mapping
functions. This only needs to be used if \code{type} is going to be used in
\code{\link[=polarMap]{polarMap()}} or another similar function, and you'd expect different values
for the different map layers (for example, if you are calculating a mean
pollutant concentration).}

\item{fun.character}{\emph{A function to summarise character and factor columns.}

\emph{default:} \code{function(x) paste(unique(x), collapse = ", ")}

The default collapses unique values into a comma-separated list.}

\item{fun.numeric}{\emph{A function to summarise numeric columns.}

\emph{default:} \code{function(x) signif(mean(x, na.rm = TRUE), 3)}

The default takes the mean to three significant figures. Other numeric
summaries may be of interest, such as the maximum, minimum, standard
deviation, and so on.}

\item{fun.dttm}{\emph{A function to summarise date columns.}

\emph{default:} \code{function(x) paste(lubridate::floor_date(range(x, na.rm = TRUE), "day"), collapse = " to ")}

The default presents the date as a range. Other statistics of interest
could be the start or end of the dates.}

\item{...}{\strong{Not currently used.}}
}
\value{
a \code{\link[tibble:tibble]{tibble::tibble()}}
}
\description{
Group a dataframe together by latitude/longitude columns and create a HTML
popup with user-defined columns. By default, the unique values of character
columns are collapsed into comma-separated lists, numeric columns are
averaged, and date columns are presented as a range. This function returns
the input dataframe appended with a "popup" column, which can then be used in
the \code{popup} argument of a function like \code{\link[=polarMap]{polarMap()}}.
}
\examples{
\dontrun{
buildPopup(
  data = polar_data,
  columns = c(
    "Site" = "site",
    "Site Type" = "site_type",
    "Date Range" = "date"
  )
) \%>\%
  polarMap("nox", popup = "popup")
}
}
