% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-surface.R
\name{otp_surface_isochrone}
\alias{otp_surface_isochrone}
\title{Make an isochrone from a surface}
\usage{
otp_surface_isochrone(otpcon = NULL, surface = NULL)
}
\arguments{
\item{otpcon}{OTP connection object produced by otp_connect()}

\item{surface}{A surface list from otp_make_surface()}
}
\value{
Returns a data.frame of travel times
}
\description{
Make a raster image (picture) of travel time using the surface features in
OTP 1.x
}
\details{
THis function requires the analysis and pointset features to be
  enabled during `otp_setup()`. Thus it will only work with OTP 1.x. For more
  detail see the analyst vignette.
}
\examples{
\dontrun{
times <- otp_surface(otpcon, c(-1.17502, 50.64590), "lsoa", path_data)
}
}
