% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optR_fit.R
\name{optR.fit}
\alias{optR.fit}
\title{Fitter function for Linear/Non-linear system with form Ax=b}
\usage{
\method{optR}{fit}(x, y = NULL, method = c("gauss, LU, gaussseidel", "cgm"),
  iter = 500, tol = 1e-07, ...)
}
\arguments{
\item{x}{: Input matrix}

\item{y}{: Response is matrix}

\item{method}{: "gauss" for gaussian elimination and "LU" for LU factorization}

\item{iter}{: Number of Iterations}

\item{tol}{: Convergence tolerance}

\item{...}{: S3 Class}
}
\value{
U    : Decomposed matrix for Gauss-ELimination Ax=b is converted into Ux=c where U is upper triangular matrix for LU decomposition U contain the values for L & U decomposition LUx=b

c    : transformed b & for LU transformation c is y from equation Ux=y

estimates  : Return x values for linear system

seq        : sequence of A matrix re-ordered
}
\description{
optR.fit is fit function for determing x for System with form Ax=b
}
\examples{
# Solving equation Ax=b
A<-matrix(c(6,-4,1, -4,6,-4,1,-4,6), nrow=3,ncol=3, byrow = TRUE)
b<-matrix(c(-14,36, 6), nrow=3,ncol=1,byrow=TRUE)
Z<-optR(A, b, method="gauss") 

# Solve Linear model using LU decomposition (Supports Multi-response)
Z<-optR(A, b, method="LU")

# Solving the function using numerical method
Z<-optR(A, b, method="cgm")
}

