% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optical.R
\name{optical}
\alias{optical}
\title{Optimal item calibration}
\usage{
optical(
  ip,
  oc = "D",
  uncert = FALSE,
  ipop,
  imf = c(0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.45),
  maxiter = rep(300, 6),
  eps = rep(0.002, 6),
  nnn = c(0, 50, 50, 200, 200, 200),
  nsp = c(0.001, 1e-04, 1e-04, 1e-05, 1e-05, 1e-05),
  sss = 0.001,
  falpha = 1.08,
  sdr = TRUE,
  ig = 3,
  ex = 0,
  integ = TRUE,
  show_progress = 1
)
}
\arguments{
\item{ip}{matrix with item parameters for all items (number of rows determines
number of items; number of column is 2 (2PL or Rasch-type with NA from second
item in first column) or 3 (3PL or mixed 2/3-PL with NA for
2PL-items in third column).}

\item{oc}{optimality criterion: "D" (D-optimality, default),
"I" (I-optimality with standard normal weight function), "A" (A-optimality).}

\item{uncert}{if false (default), abilities are assumed to be known; if true,
handling of uncertainties of Bjermo et al. (2021) is used.}

\item{ipop}{matrix with item parameters for operational items
(used if uncert=TRUE, only).}

\item{imf}{the vector of step-lengths; default
c(0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.45).}

\item{maxiter}{maximal number of iterations in each inner loop, the length
of this vector defines the number of outer loops.}

\item{eps}{convergence criterion (maximum violation of eq.th.), vector with
value for each iteration in the outer loop, but the same number for all
iterations is recommended.}

\item{nnn}{number of new nodes added at each position in the adaptive grid,
vector with value for each iteration in the outer loop (nnn [1] not used).}

\item{nsp}{node spacing between new nodes, vector with value for each iteration
in the outer loop (nsp [1] is the spacing between nodes of the starting grid).}

\item{sss}{step size stopping criterion.}

\item{falpha}{factor alpha for adjusting the step size vector (should be > 1).}

\item{sdr}{stop if design repeated (flag TRUE/FALSE).}

\item{ig}{inner grid between -ig and ig.}

\item{ex}{intervals of size < ex will be removed (consolidate);
if ex=0, no consolidation will be done.}

\item{integ}{if true (default), integrate() is used for computation of partial
information matrices; if false, Riemann rule is used.}

\item{show_progress}{if 1 (default), no output will be printed for each iteration.
If 2, the + symbols will be printed on a line for each Iteration
If 3, some output of the function will be printed.}
}
\value{
Result of this function is a list with following instances:
\item{dd}{directional derivatives of optimal solution.}
\item{xi}{optimal solution.}
\item{t}{final grid of ability values which was used.}
\item{viomax}{largest violation of eq.th. from final solution (if < eps, alg.
has converged, otherwise not).}
\item{h1}{interval boundaries for optimal solution.}
\item{ht}{Refined table of interval boundaries for optimal design with
calibrated items and their corresponding probabilities}
\item{mooiter}{monitoring iterations; information about each iteration to produce
convergence plots.}
\item{time}{running time of algorithm in minutes.}
\item{oc}{optimality criterion ("D", "I", "A", "L").}
\item{L}{L-matrix (not for D-optimality).}
}
\description{
Calibrate items following a 2PL, 3PL, mixture of 2PL and 3PL
model, or 2PL with common discrimination for all items (Rasch-type).
}
\examples{
# 2PL-models for two items; parameters (a, b)=(1.6, -1) and (1.6, 1), respectively

ip <- cbind(c(1.6, 1.6),c(-1, 1))

yyy <- optical(ip)

# Table of interval boundaries for D-optimal design with items and
# probabilities (expected proportion of examinees in this interval)
yyy$ht


\donttest{
# 1PL-models with common discrimination parameter for two items
# (model assumption is that both have same discrimination);
# parameters (a, b)=(1.6, -1) and (1.6, 1), respectively;
# NA for discrimination means that item has same parameter as preceeding item
ip <- cbind(c(1.6, NA), c(-1, 1))

yyy <- optical(ip)

# Table of interval boundaries for D-optimal design with items and
# probabilities (expected proportion of examinees in this interval)
yyy$ht


# 3PL-models for three items; parameters (a, b, c)=(1, 2, 2.5),
# (-1.5, 0.5, 2) and (0.2, 0.1, 0.05), respectively.
ip <- cbind(c(1, 2, 2.5),c(-1.5, 0.5, 2),c(0.2, 0.1, 0.05))

yyy <- optical(ip)

# Table of interval boundaries for D-optimal design with items and
# probabilities (expected proportion of examinees in this interval)
yyy$ht
}
}
\references{
Ul Hassan and Miller (2021). \href{https://www.sciencedirect.com/science/article/pii/S0167947321000116?via\%3Dihub}{An exchange algorithm for optimal calibration of items in computerized achievement tests}.\emph{Computational Statistics and
Data Analysis, 157}: 107177.

Ul Hassan and Miller (2019). \href{https://link.springer.com/article/10.1007/s11336-019-09673-6}{Optimal item calibration for computerized achievement tests}. Psychometrika, 84, 1101-1128.

Bjermo, Fackle-Fornius, and Miller (2021). \href{https://urn.kb.se/resolve?urn=urn\%3Anbn\%3Ase\%3Asu\%3Adiva-198065}{Optimizing Calibration Designs with Uncertainty in Abilities}. Manuscript.
}
\seealso{
\code{\link{drawdesign}}, \code{\link{convergenceplot}},
\code{\link{efficiency}}
}
\author{
Mahmood Ul Hassan (\email{scenic555@gmail.com});
Frank Miller (\email{frank.miller@liu.se})
}
