% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassTrtSelRelUtility.R
\docType{methods}
\name{plot.trtSelRelUtility}
\alias{plot.trtSelRelUtility}
\alias{plot,trtSelRelUtility-method}
\title{Plot the decision curves of a treatment selection marker}
\usage{
\S4method{plot}{trtSelRelUtility}(x, y, which = c(1, 2), alpha = 0.05,
  conf.int = TRUE, main1 = "Decision curves (unscaled)",
  main2 = "Decision curve (scaled)", lty = 1, lwd = 1,
  xlim = range(x@r), ylim1 = c(min(x@U, x@UT0, x@UT1, x@Up), max(x@U,
  x@UT0, x@UT1, x@Up)), ylim2 = c(0, 1), ylab1 = "Utility",
  ylab2 = "Relative utility", xlab = "r ratio", col.U = "black",
  col.Up = "red", col.UT0 = "blue", col.UT1 = "green",
  col.RU = "black", col.conf.int = "black", add = FALSE,
  legend1 = TRUE, ...)
}
\arguments{
\item{x}{a \code{trtSelRelUtility} object.}

\item{y}{unused parameter.}

\item{which}{indicates which graph should be plotted. Default is both graphs.}

\item{alpha}{alpha risk for the confidence intervals.}

\item{conf.int}{a logical value indicating whether the confidence intervals should be plotted for the relative utility curve.}

\item{main1}{an overall title for the first plot.}

\item{main2}{an overall title for the second plot.}

\item{lty}{the line type. Line types can either be specified as an integer (0=blank, 1=solid (default), 2=dashed, 3=dotted, 4=dotdash, 5=longdash, 6=twodash) or as one of the character strings "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash", where "blank" uses 'invisible lines' (i.e., does not draw them).}

\item{lwd}{the line width, a \emph{positive} number, defaulting to 1. The interpretation is device-specific, and some devices do not implement line widths less than one. (See the help on the device for details of the interpretation).}

\item{xlim}{the x limits of the plots.}

\item{ylim1}{the y limits of the first plot.}

\item{ylim2}{the y limits of the second plot.}

\item{ylab1}{a label for the y axis of the first plot.}

\item{ylab2}{a label for the y axis of the second plot.}

\item{xlab}{a label for the x axis of the plots.}

\item{col.U}{color of the utility curve for the marker-based strategy.}

\item{col.Up}{color of the utility curve for the perfect marker-based strategy.}

\item{col.UT0}{color of the utility curve for the "Treat All with the reference treatment" strategy.}

\item{col.UT1}{color of the utility curve for the "Treat All with the innovative treatment" strategy.}

\item{col.RU}{color of the relative utility curve.}

\item{col.conf.int}{color of the confidence intervals.}

\item{add}{a logical value indicating whether the relative utility curve should superimpose with an existing graph. Only works when \code{which} = 2.}

\item{legend1}{a logical value indicating whether a legend should be added to the first plot.}

\item{...}{other graphical parameters.}
}
\value{
None
}
\description{
Plot the decision curves of a treatment selection marker
}
