% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{prob.below}
\alias{prob.below}
\title{Probability Below}
\usage{
prob.below(spot, upper, mean = 0, asd = 0, dsd = 0, dte = 0, p,
  quantile = FALSE, tradedays = 262)
}
\arguments{
\item{spot}{Current price of the underlying asset}

\item{upper}{Upper price of the range}

\item{mean}{The average daily price movement, default = 0}

\item{asd}{Annualized standard deviation of the underlying returns}

\item{dsd}{Daily standard deviation of the underlying returns (Annual vol/sqrt(256)), used as an alternative to the asd parameter in conjuction with the dte parameter}

\item{dte}{Days until expiration, designated time frame}

\item{p}{Designated probability}

\item{quantile}{Logical. If True, calculates the price the asset will remain below, given the designated probability}

\item{tradedays}{Number of trade days in a year, default = 262}
}
\value{
Returns a probability (if quantile = FALSE), Returns a data.frame (if quantile = TRUE)
}
\description{
Calculates the probability of the underlying asset value remaining below a price level in a designated time frame, given the daily standard devaiation of the underlying returns.
}
\details{
This function has two separate possible operations:
1. Calculates the probability of the underlying asset value remaining below a price level in a designated time frame, given the daily standard devaiation of the underlying returns.
2. Calculates the price the asset will remain below, given the designated probability
}
\examples{
prob.below(spot = 100, upper = 110, mean = 0, dsd = 0.01, dte = 45)
prob.below(spot = 100, mean = 0, dsd = 0.01, dte = 45, p = 0.75, quantile = TRUE)
}
