% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outpack_config.R
\name{orderly_config_set}
\alias{orderly_config_set}
\title{Set configuration options}
\usage{
orderly_config_set(..., options = list(...), root = NULL)
}
\arguments{
\item{...}{Named options to set (e.g., pass the argument
\code{core.require_complete_tree = TRUE})}

\item{options}{As an alternative to \code{...}, you can pass a list of
named options here (e.g., \code{list(core.require_complete_tree = TRUE)}).  This interface is typically easier to program against.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Nothing
}
\description{
Set configuration options. Not all can currently be set; this will
be expanded over time. See Details.
}
\details{
Options are set in the order that they are provided.  Currently,
if setting one option fails, no further options will be processed
but previous ones will be (do not rely on this behaviour, it
may change).

Currently you can set:
\itemize{
\item \code{core.require_complete_tree}
}

See \code{\link[=orderly_init]{orderly_init()}} for description of these options.
}
\examples{

# The default configuration does not include a file store, and
# saves output within the "archive" directory:
path <- withr::local_tempdir()
orderly_init(path)
fs::dir_tree(path, all = TRUE)

# Change this after the fact:
orderly_config_set(core.use_file_store = TRUE,
                   core.path_archive = NULL,
                   root = path)
fs::dir_tree(path, all = TRUE)
}
\seealso{
orderly_config
}
