% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin.R
\name{orderly_plugin_register}
\alias{orderly_plugin_register}
\title{Register an orderly plugin}
\usage{
orderly_plugin_register(
  name,
  config,
  serialise = NULL,
  deserialise = NULL,
  cleanup = NULL,
  schema = NULL
)
}
\arguments{
\item{name}{The name of the plugin, typically the package name}

\item{config}{A function to read, check and process the
configuration section in the orderly configuration.  This
function will be passed the deserialised data from the plugin's
section of \verb{orderly_config.json, and the full path to that file. As the order of loading of plugins is not defined, each plugin must standalone and should not try and interact with other plugins at load. It should return a processed copy of the configuration data, to be passed in as the second argument to }read`.}

\item{serialise}{A function to serialise any metadata added by the
plugin's functions to the outpack metadata. It will be passed a
list of all entries pushed in via
\code{\link[=orderly_plugin_add_metadata]{orderly_plugin_add_metadata()}}; this is a named
list with names corresponding to the \code{field} argument to
\code{orderly_plugin_add_metadata} and each list element being an
unnamed list with values corresponding to \code{data}. If \code{NULL},
then no serialisation is done, and no metadata from your plugin
will be added.}

\item{deserialise}{A function to deserialise any metadata
serialised by the \code{serialise} function. This is intended to help
deal with issues disambiguating unserialising objects from json
(scalars vs arrays of length 1, data.frames vs lists-of-lists
etc), and will make your plugin nicer to work with
\code{\link[=orderly_metadata_extract]{orderly_metadata_extract()}}. This function will be
given a single argument \code{data} which is the data from
\code{jsonlite::fromJSON(..., simplifyVector = FALSE)} and you should
apply any required simplifications yourself, returning a
modified copy of the argument.}

\item{cleanup}{Optionally, a function to clean up any state that
your plugin uses. You can call \code{orderly_plugin_context} from
within this function and access anything you need from that. If
not given, then no cleanup is done.}

\item{schema}{Optionally a path, within the package, to a schema
for the metadata created by this plugin; you should omit the
\code{.json} extension.  So if your file contains in its sources the
file \code{inst/plugin/myschema.json} you would pass
\code{plugin/myschema}.  See \code{vignette("plugins")} for details.}
}
\value{
Nothing, this function is called for its side effect of
registering a plugin.
}
\description{
Create an orderly plugin. A plugin is typically defined by a
package and is used to extend orderly by enabling new
functionality, declared in your orderly configuration
(\code{orderly_config.json}) and your orderly file (\verb{<name>.R}), and
affecting the running of reports primarily by creating new objects
in the report environment.  This system is discussed in more
detail in \code{vignette("plugins")}.
}
\examples{
# The example code from vignette("plugins") is available in the package
fs::dir_tree(system.file("examples/example.db", package = "orderly"))

# See orderly_plugin_register in context here:
orderly_example_show("R/plugin.R", example = "example.db")
}
