% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{orderly_run}
\alias{orderly_run}
\title{Run a report}
\usage{
orderly_run(
  name,
  parameters = NULL,
  envir = NULL,
  echo = TRUE,
  location = NULL,
  allow_remote = NULL,
  fetch_metadata = FALSE,
  search_options = NULL,
  root = NULL
)
}
\arguments{
\item{name}{Name of the report to run. Any leading \verb{./} \verb{src/} or
trailing \code{/} path parts will be removed (e.g., if added by
autocomplete).}

\item{parameters}{Parameters passed to the report. A named list of
parameters declared in the \code{orderly.yml}.  Each parameter
must be a scalar character, numeric, integer or logical.}

\item{envir}{The environment that will be used to evaluate the
report script; by default we use the global environment, which
may not always be what is wanted.}

\item{echo}{Optional logical to control printing output from
\code{source()} to the console.}

\item{location}{Optional vector of locations to pull from. We
might in future expand this to allow wildcards or exceptions.}

\item{allow_remote}{Logical, indicating if we should allow packets
to be found that are not currently unpacked (i.e., are known
only to a location that we have metadata from). If this is
\code{TRUE}, then in conjunction with \code{\link[=orderly_dependency]{orderly_dependency()}}
you might pull a large quantity of data.  The default is \code{NULL}. This is
\code{TRUE} if remote locations are listed explicitly as a character
vector in the \code{location} argument, or if you have specified
\code{fetch_metadata = TRUE}, otherwise \code{FALSE}.}

\item{fetch_metadata}{Logical, indicating if we should pull
metadata immediately before the search. If \code{location} is given,
then we will pass this through to
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to filter locations
to update.  If pulling many packets in sequence, you \emph{will} want
to update this option to \code{FALSE} after the first pull, otherwise
it will update the metadata between every packet, which will be
needlessly slow.}

\item{search_options}{\strong{DEPRECATED}. Please don't use this any
more, and instead use the arguments \code{location}, \code{allow_remote}
and \code{fetch_metadata} directly.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function \strong{does} require that the directory is
configured for orderly, and not just outpack (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
The id of the created report (a string)
}
\description{
Run a report.  This will create a new directory in
\verb{drafts/<reportname>}, copy your declared resources there, run
your script and check that all expected artefacts were created.
}
\section{Locations used in dependency resolution}{


If your packet depends on other packets, you will want to control
the locations that are used to find appropriate packets. The
control for this is passed through this function and \emph{not} as an
argument to \code{\link[=orderly_dependency]{orderly_dependency()}} because this is a property of
the way that a packet is created and not of a packet itself;
importantly different users may have different names for their
locations so it makes little sense to encode the location name
into the source code. Alternatively, you want to use different
locations in different contexts, for example sometimes you might
want to include local copies of packets as possible dependencies,
but at other times you want to resolve dependencies only as they
would be resolved on one of your locations.

Similarly, you might want to include packets that are known by
other locations but are not currently downloaded onto this
machine - pulling these packets in could take anything from
seconds to hours depending on their size and the speed of your
network connection (but \emph{not} pulling in the packets could mean
that your packet fails to run).

To allow for control over this you can pass in an arguments to
control the names of the locations to use, whether metadata
should be refreshed before we pull anything and if packets that
are not currently downloaded should be considered candidates.

This has no effect when running interactively, in which case you
can specify the search options (root specific) with
\code{\link[=orderly_interactive_set_search_options]{orderly_interactive_set_search_options()}}
}

\section{Which packets might be selected from locations?}{


The arguments \code{location}, \code{allow_remote} and \code{fetch_metadata}
control where outpack searches for packets with the given query
and if anything might be moved over the network (or from one
outpack archive to another). By default everything is resolved
locally only; that is we can only depend on packets that are
unpacked within our current archive.  If you pass \code{allow_remote = TRUE}, then packets that are known anywhere are candidates for
using as dependencies and \emph{if needed} we will pull the resolved
files from a remote location. Note that even if the packet is
not locally present this might not be needed - if you have the
same content anywhere else in an unpacked packet we will reuse
the same content without re-fetching.

If \code{fetch_metadata = TRUE}, then we will refresh location metadata
before pulling, and the \code{location} argument controls which
locations are pulled from.
}

\section{Equivalence to the old \code{use_draft} option}{


The above location handling generalises the version 1.x of
orderly's previous \code{use_draft} option, in terms of the new
\code{location} argument:
\itemize{
\item \code{use_draft = TRUE} is \code{location = "local"}
\item \code{use_draft = FALSE} is \code{location = c(...)} where you should provide
all locations \emph{except} local
(\code{setdiff(orderly_location_list(), "local")})
\item \code{use_draft = "newer"} is \code{location = NULL}
}

(this last option was the one most people preferred so is the new
default behaviour). In addition, you could resolve dependencies
as they currently exist on production right now with the options:

\if{html}{\out{<div class="sourceCode">}}\preformatted{location = "production", fetch_metadata = TRUE
}\if{html}{\out{</div>}}

which updates your current metadata from production, then runs
queries against only packets known on that remote, then depends
on them even if you don't (yet) have them locally.  This
functionality was never available in orderly version 1, though
we had intended to support it.
}

\section{Running with a source tree separate from outpack root}{


Sometimes it is useful to run things from a different place on
disk to your outpack root. We know of two cases where this has
come up:
\itemize{
\item when running reports within a runner on a server, we make a
clean clone of the source tree at a particular git reference
into a new temporary directory and then run the report there,
but have it insert into an orderly repo at a fixed and
non-temporary location.
\item we have a user for whom it is more convenient to run their report
on a hard drive but store the archive and metadata on a (larger)
shared drive.
}

In the first instance, we have a source path at \verb{<src>} which
contains the file \code{orderly_config.json} and the directory \verb{src/}
with our source reports, and a separate path \verb{<root>} which
contains the directory \verb{.outpack/} with all the metadata - it
may also have an unpacked archive, and a \verb{.git/} directory
depending on the configuration. (Later this will make more sense
once we support a "bare" outpack layout.)
}

\section{Manually setting report source directory}{


To manually set the report source directory, you will need to set
the path of the directory as the \code{ORDERLY_REPORT_SRC} environment
variable.
}

\examples{
# Create a simple example:
path <- orderly_example()

# Run the 'data' task:
orderly_run("data", root = path)

# After running, a finished packet appears in the archive:
fs::dir_tree(path)

# and we can query the metadata:
orderly_metadata_extract(name = "data", root = path)
}
