% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{orderly_run_info}
\alias{orderly_run_info}
\title{Information about currently running report}
\usage{
orderly_run_info()
}
\value{
A list with elements
\itemize{
\item \code{name}: The name of the current report
\item \code{id}: The id of the current report, \code{NA} if running interactively
\item \code{root}: The orderly root path
\item \code{depends}: A data frame with information about the dependencies
(not available interactively)
\itemize{
\item \code{index}: an integer sequence along calls to \code{\link[=orderly_dependency]{orderly_dependency()}}
\item \code{name}: the name of the dependency
\item \code{query}: the query used to find the dependency
\item \code{id}: the computed id of the included packet
\item \code{filename}: the file used from the packet
\item \code{as}: the filename used locally
}
}
}
\description{
Fetch information about the actively running report.  This allows
you to reflect information about your report back as part of the
report, for example embedding the current report id, or
information about computed dependencies. This information is in a
slightly different format to orderly version 1.x and does not
(currently) include information about dependencies when run
outside of \code{\link[=orderly_run]{orderly_run()}}, but this was never reliable
previously.
}
\examples{
# An example from the orderly examples
orderly_example_show("run_info")

# Prepare to run
path <- orderly_example()
orderly_run("data", root = path, echo = FALSE)

# Here, see the printed information from a real running report
orderly_run("run_info", root = path)
}
