% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_ordgam_plot.R
\name{plot.ordgam}
\alias{plot.ordgam}
\title{Plot the the additive terms in an <ordgam> object with its credible regions}
\usage{
\method{plot}{ordgam}(x,ngrid=300,ci.level=.95,mfrow=NULL,...)
}
\arguments{
\item{x}{An \link{ordgam.object} generated by \link{ordgam}.}

\item{ngrid}{An integer indicating the number of gridpoints where the additive terms should be evaluated.}

\item{ci.level}{Credibility level for the pointwise credible region of the additive terms.}

\item{mfrow}{(Optional) A vector of the form c(nr, nc). Subsequent figures will be drawn in an nr-by-nc array on the device by rows.}

\item{...}{Additional generic plotting arguments.}
}
\value{
In addition to the plots, an invisible object containing information on the estimated additive terms is returned, see the \code{ordgam_additive} function documentation for more details.
}
\description{
Plot the the additive terms in an object generated by \code{ordgam} with its credible regions
}
\examples{
library(ordgam)
data(freehmsData)
mod = ordgam(freehms ~ gndr + s(eduyrs) + s(age),
             data=freehmsData, descending=TRUE)
print(mod)
plot(mod)

}
\references{
Lambert, P. and Gressani, 0. (2023) Penalty parameter selection and asymmetry corrections
to Laplace approximations in Bayesian P-splines models. Statistical Modelling. <doi:10.1177/1471082X231181173>. Preprint: <arXiv:2210.01668>.
}
\seealso{
\code{\link{ordgam}}, \code{\link{ordgam.object}}, \code{ordgam.additive}, \code{\link{print.ordregr}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
